<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2015 Jim Dudek AKA Nhawk/Snog                        # ||
|| # All Rights Reserved.                                             # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # License: NULLXF99999999999                                       # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this file on your server unless       # ||
|| # you have purchased the raffle system from snogssite.com.         # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class Snog_Raffles_Model_Raffle extends XenForo_Model
{
	public function getRaffles()
	{
		return $this->_getDb()->fetchAll('
			SELECT *
			FROM xf_raffles
			ORDER BY raffle_id'
		);
	}

	public function getActiveRaffles($current_date)
	{
		if(!XenForo_Application::getOptions()->raffles_showold)
		{
			return $this->_getDb()->fetchAll('
				SELECT *
				FROM xf_raffles
				WHERE start_timestamp <= ' . $current_date . '
				AND winner = ""
				ORDER BY draw_timestamp ASC'
			);
		}else{
			return $this->_getDb()->fetchAll('
				SELECT *
				FROM xf_raffles
				WHERE start_timestamp <= ' . $current_date . '
				ORDER BY draw_timestamp DESC'
			);
		}
	}
	
	public function getSidebarActiveRaffles($current_date)
	{
		return $this->_getDb()->fetchAll('
			SELECT *
			FROM xf_raffles
			WHERE start_timestamp <= ' . $current_date . '
			AND stop_timestamp >= ' . $current_date . '
			AND winner = ""
			AND insidebar = "1"
			ORDER BY draw_timestamp ASC'
		);
	}

	public function getOldRaffles($current_date)
	{
		return $this->_getDb()->fetchAll('
			SELECT *
			FROM xf_raffles
			WHERE start_timestamp <= ' . $current_date . '
			AND winner > ""
			ORDER BY draw_timestamp DESC'
		);
	}

	public function getRaffleEntry($raffleId)
	{
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM xf_raffles_entries
			WHERE raffle_id = ?
			AND start_timestamp <= ' . $current_date . '
			AND FIND_IN_SET("' . $visitor['user_group_id'] . '",usergroups)
			AND FIND_IN_SET("' . $visitor['user_group_id'] . '",badusergroups) = 0
		', $raffleId);
	}

	public function getRaffle($raffleId)
	{
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM xf_raffles
			WHERE raffle_id = ?
		', $raffleId);
	}

	public function drawActiveRaffles($current_date)
	{
			return $this->_getDb()->fetchAll('
				SELECT *
				FROM xf_raffles
				WHERE draw_timestamp <= ' . $current_date . '
				AND winner = ""
				ORDER BY draw_timestamp ASC'
			);
	}

	public function getRaffleWinner($raffleId)
	{
			return $this->_getDb()->fetchRow('
				SELECT entry_id, user_id
				FROM xf_raffles_entries
				WHERE raffle_id = ' . $raffleId . '
				ORDER BY RAND() LIMIT 1'
			);
	}

	public function raffleWinnerUpdate($raffle_id, $winners)
	{
		$this->_getDb()->query(
			'UPDATE xf_raffles
			SET  winner = "' . $winners . '"
			WHERE raffle_id = ?'		
		, $raffle_id);
		return true;
	}

	public function raffleImageUpdate($raffle_id, $image)
	{

		$this->_getDb()->query(
			'UPDATE xf_raffles
			SET  image = "' . $image . '"
			WHERE raffle_id = ?'		
		, $raffle_id);
		return true;
	}

	public function getRaffleImage($raffleId)
	{
		return $this->_getDb()->fetchRow('
			SELECT image
			FROM xf_raffles
			WHERE raffle_id = ?
		', $raffleId);
	}

	public function raffleDelete($raffleId)
	{
		$affected = $this->_getDb()->query('
			DELETE FROM xf_raffles
			WHERE raffle_id = ?', $raffleId);

		$entrydel = $this->_getDb()->query('
			DELETE FROM xf_raffles_entries
			WHERE raffle_id = ?', $raffleId);
		return true;
	}
}