<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2015 Jim Dudek AKA Nhawk/Snog                        # ||
|| # All Rights Reserved.                                             # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # License: NULLXF99999999999                                       # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this file on your server unless       # ||
|| # you have purchased the raffle system from snogssite.com.         # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class Snog_Raffles_Model_Node extends XenForo_Model
{
	public function getRaffleNodeOptions(array $nodes, $selectedNodeId = 0)
	{
		$options = array();

		foreach ($nodes AS $nodeId => $node)
		{
			$options[$nodeId] = array(
				'value' => $nodeId,
				'label' => $node['title'],
				'depth' => $node['depth']
			);

			if (!empty($node['node_type_id']) && $node['node_type_id'] != 'Forum') $options[$nodeId]['disabled'] = 'disabled';
		}

		return $options;
	}
}  