<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2015 Jim Dudek AKA Nhawk/Snog                        # ||
|| # All Rights Reserved.                                             # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # License: NULLXF99999999999                                       # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this file on your server unless       # ||
|| # you have purchased the raffle system from snogssite.com.         # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class Snog_Raffles_Listener_NavTab
{
	public static function createTab(array &$extraTabs, $selectedTabId)
	{
		if(XenForo_Application::getOptions()->raffles_in_navbar)
		{
			$visitor = XenForo_Visitor::getInstance();

			if ($visitor->hasPermission('raffles', 'viewRaffles'))
			{		
				$extraTabs['raffles'] = array(
					'title'				=> new XenForo_Phrase('raffles_title'),
					'href'				=> XenForo_Link::buildPublicLink('raffles'),
					'position'			=> 'middle',
					'linksTemplate'		=> 'raffles_navlinks'
				);
			}
		}
	}
}