<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2015 Jim Dudek AKA Nhawk/Snog                        # ||
|| # All Rights Reserved.                                             # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # License: NULLXF99999999999                                       # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this file on your server unless       # ||
|| # you have purchased the raffle system from snogssite.com.         # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class Snog_Raffles_Helper_DataWriter
{
	static public function createThread($user, $forumId, $subject, $message)
	{
		$writer = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');
		$writer->set('user_id', $user['user_id']);
		$writer->set('username', $user['username']);
		$writer->set('title', $subject);
		$postWriter = $writer->getFirstMessageDw();
		$postWriter->set('message', $message);
		$writer->set('node_id', $forumId);
		$writer->preSave();
		$writer->save();
		return $writer->getMergedData();
	}

	static public function createConversation(array $sender, array $recipients, $subject, $message, $noInvites = false, $conversationClosed = false, $markReadForSender = true)
	{
		$conversationDw = XenForo_DataWriter::create('XenForo_DataWriter_ConversationMaster');
		$conversationDw->set('user_id', $sender['user_id']);
		$conversationDw->set('username', $sender['username']);
		$conversationDw->set('title', $subject);
		$conversationDw->set('open_invite', 0);
		$conversationDw->set('conversation_open', 0);
		$conversationDw->addRecipientUserIds($recipients);
		$messageDw = $conversationDw->getFirstMessageDw();
		$messageDw->set('message', $message);
		$conversationDw->preSave();
		$conversationDw->save();
		$conversation = $conversationDw->getMergedData();
		$convModel = XenForo_Model::create('XenForo_Model_Conversation');
		if ($markReadForSender) $convModel->markConversationAsRead($conversation['conversation_id'], $sender['user_id'], XenForo_Application::$time);
		return $conversationDw->getMergedData();
	}
}