<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2015 Jim Dudek AKA Nhawk/Snog                        # ||
|| # All Rights Reserved.                                             # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # License: NULLXF99999999999                                       # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this file on your server unless       # ||
|| # you have purchased the raffle system from snogssite.com.         # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class Snog_Raffles_DataWriter_Entries extends XenForo_DataWriter
{
	protected function _getFields()
	{
		return array(
			'xf_raffles_entries' => array(
				'entry_id'	=> array('type' => self::TYPE_UINT, 'autoIncrement' => true),
				'raffle_id'=> array('type' => self::TYPE_UINT, 'required' => false),
				'user_id'=> array('type' => self::TYPE_UINT, 'required' => false),
				'timestamp'=> array('type' => self::TYPE_UINT, 'required' => false)
			)
		);
	}

	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data, 'entry_id'))
		{
			return false;
		}
		
		return array('xf_raffles_entries' => $this->getModelFromCache('Snog_Raffles_Model_Entries')->getEntry($id));
		
	}

	protected function _getUpdateCondition($tableName)
	{
		return 'entry_id = ' . $this->_db->quote($this->getExisting('entry_id'));
	}
	
	protected function _postDelete()
	{
		$this->getModelFromCache('Snog_Raffles_Model_Entries')->entryDelete($this->get('entry_id'));
	}
}
