<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2015 Jim Dudek AKA Nhawk/Snog                        # ||
|| # All Rights Reserved.                                             # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # License: NULLXF99999999999                                       # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this file on your server unless       # ||
|| # you have purchased the raffle system from snogssite.com.         # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class Snog_Raffles_ControllerAdmin_Entries extends XenForo_ControllerAdmin_Abstract
{
	protected function _preDispatch($action)
	{
		$this->assertAdminPermission('raffles');
	}
	
	public function actionIndex()
	{
		$filters = $this->_input->filterSingle('filters', XenForo_Input::ARRAY_SIMPLE);
		$page = max(1, $this->_input->filterSingle('page', XenForo_Input::UINT));
		$perPage = 50;
		if($page < 1) $page = 1;

		// sets pagination fetch options
		$fetchOptions['page'] = $page;
		$fetchOptions['limit'] = $perPage;

		// processes filters
		$conditions['raffle_name'] = '';
		$conditions['user_id'] = '';
		$linkParams['filters[rafflename]'] = '';
		$linkParams['filters[username]'] = '';
		if (!empty($filters['username'])) {
			$user = $this->getModelFromCache('XenForo_Model_User')->getUserByName($filters['username']);
			if (!empty($user)) {
				$filters['username'] = $user['username'];
				$conditions['user_id'] = $user['user_id'];
				$linkParams['filters[username]'] = $user['username'];
			}else{
				throw new XenForo_Exception(new XenForo_Phrase('requested_user_not_found'), true);
			}
		}

		if (!empty($filters['rafflename'])) {
			$conditions['raffle_name'] = $filters['rafflename'];
			$linkParams['filters[rafflename]'] = $filters['rafflename'];
		}

		$entries = $this->_getEntriesModel()->getEntriesPaged($fetchOptions,$conditions);
		$total_entries = $this->_getEntriesModel()->countEntries($conditions);
		$viewParams = array('entries' => $entries,
			'page' => $page,
			'perPage' => $perPage,
			'filters' => $filters,
			'linkParams' => $linkParams,
			'total' => $total_entries
		);
		return $this->responseView('Snog_Raffles_ViewAdmin_Index', 'raffles_entry_list', $viewParams);
	}

	public function actionDelete()
	{
		if ($this->isConfirmedPost())
		{
			$entry_id = $this->_input->filterSingle('entry_id', XenForo_Input::UINT);
			$this->_getEntriesModel()->refundPayment($entry_id);
			return $this->_deleteData('Snog_Raffles_DataWriter_Entries', 'entry_id',XenForo_Link::buildAdminLink('entries'));
		}else{
			$entry_id = $this->_input->filterSingle('entry_id', XenForo_Input::UINT);
			$entry = $this->_getEntryOrError($entry_id);
			$viewParams = array('entry' => $entry);
			return $this->responseView('Snog_Raffles_ViewAdmin_Entry_Delete', 'raffles_entry_delete_confirm', $viewParams);
		}
	}

	public function getEntry($entryId)
	{
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM xf_raffles_entries
			WHERE raffle_id = ?
		', $entryId);
	}


	protected function _getRaffleModel()
	{
		return $this->getModelFromCache('Snog_Raffles_Model_Raffle');
	}	

	protected function _getEntriesModel()
	{
		return $this->getModelFromCache('Snog_Raffles_Model_Entries');
	}	

	protected function _getEntryOrError($entry_id)
	{
		$info = $this->_getEntriesModel()->getEntry($entry_id);
		if (!$info) throw $this->responseException($this->responseError(new XenForo_Phrase('raffles_raffle_notfound'), 404));
		return $info;
	}
}