/** @param {jQuery} $ jQuery Object */
!function($, window, document, _undefined)
{

    XT_Framework = function(params) {
        /* Loaded */
    };

    XT_Framework.prototype.showHide = function(trig,dest,callback) {
            $(trig).on("click", function(e) {
                e.preventDefault();

                var offset = trig.offset(),
                    offsetTop = offset.top + $(".top-bar").outerHeight();

                if (!dest.is(':visible')) {
                    dest.css({top:offsetTop,left:offset.left}).show();
                    if (callback()) { callback(); }
                } else {
                    dest.hide();
                }
            });

            $("body").on("click", function(e) {
                if( $(e.target).closest(trig).length > 0 || $(e.target).closest(dest).length) {
                    return;
                }
                if (dest.is(':visible')) {
                    dest.hide();
                }
            });
    };

    XT_Framework.prototype.scrollTop = function(trig) {
        $("html,body").animate({ scrollTop: 0 }, "fast");
    };

    XT_Framework.prototype.showAfterDistanceScrolled = function(item, distance) {
        var didScroll = false, w = $(window);

        w.scroll(function() { didScroll = true; });

        setInterval(function() {
            if(didScroll) {
                didScroll = false;
                if(w.scrollTop() > distance ) {
                    item.fadeIn("fast");
                } else {
                    item.fadeOut("fast");
                }
            }
        }, 250);
    };

    $(function() {

        var xt = new XT_Framework();

       /*-----------------------------------------------------------------------------------*/
        /*  Customiser
        /*-----------------------------------------------------------------------------------*/
        var bgPicker = $(".bgPicker"),
            bgChooser = $(".bgChooser"),
            closeBgChooser =  $(".closeBgChooser"),
            item = $(".bgChooser ul li");
     
        bgPicker.on('click',function(e) {
            e.preventDefault();
            if (bgPicker.hasClass('active')) {
                bgChooser.addClass("zoomOut");
                setTimeout(function() {
                    bgChooser.hide();
                },600);
                bgPicker.removeClass('active');
                return false;
            }
            bgPicker.addClass('active');
            bgChooser.show().removeClass("zoomOut").addClass("zoomIn");
        });

        closeBgChooser.on('click',function(e) {
            e.preventDefault();
            bgChooser.addClass("zoomOut");
            setTimeout(function() {
                bgChooser.hide();
            },600);
            bgPicker.removeClass('active');
        });

        var body = $("body"),
            cookieExpiry = new Date(new Date().getTime() + xt_customiserExpiry * 86400000);

        item.on('click',function(e) {
            var type = $(this).parent().attr('class');
            e.preventDefault();
            var id = $(this).attr('data-'+type+'');
            $.setCookie('cookie'+type+'',id,cookieExpiry);
            body.attr('data-'+type+'',id);
        });
        
        var customiserCookies = {"bg":$.getCookie('cookiebg'),"msg":$.getCookie('cookiemsg') };

        if ((customiserCookies.bg != null)) {
            body.attr('data-bg',customiserCookies.bg);
        } else {
            body.attr('data-bg','bg-default');
        }
        
        if ((customiserCookies.msg != null)) {
            body.attr('data-msg',customiserCookies.msg);
        } else {
            body.attr('data-msg','bg-default');
        }

        /**
        * Search Show & Hide
        */
        if ($("#searchBar").length > 0) {
            var trig = $(".SearchTrigger"), 
                dest = $("#searchBar"), 
                callback = function() {
                    dest.find("#QuickSearchPlaceholder").trigger("click");
                };
            xt.showHide(trig,dest,callback);
        }

        /**
        * Smooth Scroll Top
        */
        var item = $(".topLink"), distance = 350;

        item.on("click",function(e) {
            xt.scrollTop();
            e.preventDefault();
        });

        xt.showAfterDistanceScrolled(item,distance);


        /**
        * Responsive logo
        */
        if(xt_responsive_logo) {
            var $logo = $("#logo h1");
            $("#logo h1").fitText(0.8, { minFontSize: '30px', maxFontSize: '70px' });   
        }

    });
 
    /**
    * jQuery fitText plugin
    */
    $.fn.fitText = function( kompressor, options ) {

        // Setup options
        var compressor = kompressor || 1,
            settings = $.extend({
              'minFontSize' : Number.NEGATIVE_INFINITY,
              'maxFontSize' : Number.POSITIVE_INFINITY
            }, options);

        return this.each(function(){

          // Store the object
          var $this = $(this);

          // Resizer() resizes items based on the object width divided by the compressor * 10
          var resizer = function () {
            $this.css('font-size', Math.max(Math.min($this.width() / (compressor*10), parseFloat(settings.maxFontSize)), parseFloat(settings.minFontSize)));
          };

          // Call once to set.
          resizer();

          // Call on resize. Opera debounces their resize by default.
          $(window).on('resize.fittext orientationchange.fittext', resizer);

        });

    };


}
(jQuery, this, document);