<?php

$startTime = microtime(true);

$fileDir = dirname(__FILE__);
if (file_exists($fileDir . '/301config.php'))
{
	include($fileDir . '/301config.php');
}

require($fileDir . '/library/XenForo/Autoloader.php');
XenForo_Autoloader::getInstance()->setupAutoloader($fileDir . '/library');

XenForo_Application::initialize($fileDir . '/library', $fileDir);
XenForo_Application::set('page_start_time', $startTime);

$inputHandler = new XenForo_Input(new Zend_Controller_Request_Http());

$input = $inputHandler->filter(array(
	'f' => XenForo_Input::UINT,
));
$http = new Zend_Controller_Request_Http();
if(preg_match('/forumdisplay\.php(?:\/|\?)([0-9]+)(?:-[^\/]+)/', $http->getRequestUri(), $matches) && count($matches) >= 1){    
	$input['f'] = intval($matches[1]);
}

$target = false;
if ($input['f'])
{
	$importModel = XenForo_Model::create('XenForo_Model_Import');

	if ($newId = $importModel->mapNodeId($input['f']))
	{
		$target = XenForo_Link::buildPublicLink('canonical:forums', array('node_id' => $newId));
	}
}

if (!$target)
{
	$target = XenForo_Link::buildPublicLink('canonical:index');
}

$response = new Zend_Controller_Response_Http();
$response->setRedirect(XenForo_Link::convertUriToAbsoluteUri($target), 301);
$response->sendResponse();