<?php

$startTime = microtime(true);

$fileDir = dirname(__FILE__);
if (file_exists($fileDir . '/301config.php'))
{
	include($fileDir . '/301config.php');
}

require($fileDir . '/library/XenForo/Autoloader.php');
XenForo_Autoloader::getInstance()->setupAutoloader($fileDir . '/library');

XenForo_Application::initialize($fileDir . '/library', $fileDir);
XenForo_Application::set('page_start_time', $startTime);

$http = new Zend_Controller_Request_Http();

$inputHandler = new XenForo_Input($http);

$input = $inputHandler->filter(array(
	'u' => XenForo_Input::UINT,
));
if(preg_match('/member\.php(?:\/|\?)([0-9]+)/', $http->getRequestUri(), $matches) && count($matches) >= 1){    
	$input['u'] = intval($matches[1]);
}

$target = false;
if ($input['u'])
{
	$importModel = XenForo_Model::create('XenForo_Model_Import');

	if ($newId = $importModel->mapUserId($input['u']))
	{
		$target = XenForo_Link::buildPublicLink('canonical:members', array('user_id' => $newId));
	}
}

if (!$target)
{
	$target = XenForo_Link::buildPublicLink('canonical:index');
}

$response = new Zend_Controller_Response_Http();
$response->setRedirect(XenForo_Link::convertUriToAbsoluteUri($target), 301);
$response->sendResponse();