<?php

class XenPushover_Listener
{
	protected static $_hasTemplatePerm = null;

	public static function templateCreate($templateName, array &$params, XenForo_Template_Abstract $template)
	{
		if (self::$_hasTemplatePerm === null)
		{
			self::$_hasTemplatePerm = XenForo_Visitor::getInstance()->hasPermission('general', 'associateXenPushover');
		}

		if (!isset($params['canUseXenPushover']))
		{
			$params['canUseXenPushover'] = self::$_hasTemplatePerm;
		}
	}

	public static function extendAccountController($class, array &$extend)
	{
		$extend[] = 'XenPushover_ControllerPublic_Account';
	}

	public static function extendAlertWriter($class, array &$extend)
	{
		$extend[] = 'XenPushover_DataWriter_Alert';
	}

	public static function extendUserWriter($class, array &$extend)
	{
		$extend[] = 'XenPushover_DataWriter_User';
	}

	public static function criteriaUser($rule, array $data, array $user, &$returnValue)
	{
		switch ($rule)
		{
			case 'xenpushover':
				if (empty($user['externalAuth']['xenpushover']))
				{
					$returnValue = false;
				}
				else
				{
					$returnValue = true;
				}
			break;
		}
	}
}