<?php

class XenPushover_CronEntry_AdminAlerts
{
	public static function checkForServerErrors()
	{
		$options = XenForo_Application::getOptions();
		if (!$options->xenpushoverAdminKey || !$options->xenpushoverApiToken)
		{
			return;
		}

		/** @var $logModel XenForo_Model_Log */
		$logModel = XenForo_Model::create('XenForo_Model_Log');
		$count = $logModel->countServerErrors();

		if ($count)
		{
			/** @var $pushoverModel XenPushover_Model_Pushover */
			$pushoverModel = XenForo_Model::create('XenPushover_Model_Pushover');

			$alertType = $pushoverModel->getAdminAlertType('server_error');
			if ($alertType['enabled']
				&& $alertType['last_sent'] <= (XenForo_Application::$time - 86400)
				&& !$alertType['emergency_receipt']
			)
			{
				$receipt = $pushoverModel->pushAdminAlert($alertType);
				if (!$receipt)
				{
					return false;
				}

				$dwInput = array();
				if ($alertType['priority'] == 'emergency')
				{
					$dwInput['emergency_receipt'] = $receipt;
				}
				$dwInput['last_sent'] = XenForo_Application::$time;

				$dw = XenForo_DataWriter::create('XenPushover_DataWriter_AdminAlerts');

				$dw->setExistingData('server_error', true);
				$dw->bulkSet($dwInput);

				return $dw->save();
			}
		}

		return false;
	}
}