<?php

class XenPushover_ControllerPublic_Pushover extends XenForo_ControllerPublic_Abstract
{
	public function actionIndex()
	{
		$this->_assertPostOnly();

		$receivedData = $this->_input->filter(array(
			'receipt' => XenForo_Input::STRING,
			'acknowledged' => XenForo_Input::BOOLEAN,
			'acknowledged_at' => XenForo_Input::UINT,
			'acknowledged_by' => XenForo_Input::STRING
		));

		foreach ($receivedData AS $key => $input)
		{
			if (!$input)
			{
				throw $this->responseException(
					$this->responseError(new XenForo_Phrase('xenpushover_please_provide_expected_parameter_x', array('param' => $key)), 403)
				);
			}
		}

		/** @var $pushoverModel XenPushover_Model_Pushover */
		$pushoverModel = $this->getModelFromCache('XenPushover_Model_Pushover');
		$adminAlert = $pushoverModel->getAdminAlertFromReceipt($receivedData['receipt']);

		if (!$adminAlert)
		{
			throw $this->responseException(
				$this->responseError(new XenForo_Phrase('xenpushover_please_provide_expected_parameter_x', array('param' => 'receipt')), 403)
			);
		}

		$dw = XenForo_DataWriter::create('XenPushover_DataWriter_AdminAlerts');

		$dw->setExistingData($adminAlert);
		$dw->set('emergency_receipt', '');
		$dw->set('last_sent', XenForo_Application::$time);

		$dw->save();

		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildPublicLink('index')
		);
	}

	protected function _checkCsrf($action)
	{
		if (strtolower($action) == 'index')
		{
			return;
		}

		parent::_checkCsrf($action);
	}
}