<?php

class XenPushover_ControllerPublic_Account extends XFCP_XenPushover_ControllerPublic_Account
{
	public function actionExternalAccounts()
	{
		$parent = parent::actionExternalAccounts();

		if (($parent instanceof XenForo_ControllerResponse_View))
		{
			/** @var $pushoverModel XenPushover_Model_Pushover */
			$pushoverModel = $this->getModelFromCache('XenPushover_Model_Pushover');

			$params = $parent->subView->params['external'];
			if (!empty($params['xenpushover']))
			{
				$contentTypePhrases = array();

				$alertTypes = $pushoverModel->getAlertTypesForPushover();
				foreach ($alertTypes AS $contentType => &$alertType)
				{
					$enabledCount = 0;

					foreach ($alertType AS $action => &$item)
					{
						if ($item['enabled'])
						{
							$phrase = new XenForo_Phrase($pushoverModel->getFriendlyNamePhraseName($contentType, $action));
							$item['friendlyName'] = $phrase->render(false);

							$enabledCount++;
						}
					}

					if ($enabledCount)
					{
						$phrase = new XenForo_Phrase($pushoverModel->getFriendlyNamePhraseName($contentType));
						$contentTypePhrases[$contentType] = $phrase->render(false);
					}
				}

				$params['xenpushover'] = array_merge($params['xenpushover'], array(
					'extra_data' => @unserialize($params['xenpushover']['extra_data']),
					'sounds' => $pushoverModel->getNotificationSounds(),
					'priorities' => $pushoverModel->getPriorityLevels(),
					'alertTypes' => $pushoverModel->mergeOptOutsAndPriorities(
						$alertTypes,
						$pushoverModel->getAlertOptOuts(null),
						$pushoverModel->getAlertPriorities(null)
					),
					'contentTypePhrases' => $contentTypePhrases,
				));
			}
			$parent->subView->params['external'] = $params;
		}

		return $parent;
	}

	public function actionExternalAccountsPushover()
	{
		$this->_assertPostOnly();

		$visitor = XenForo_Visitor::getInstance();

		$auth = $this->_getUserModel()->getUserAuthenticationObjectByUserId($visitor['user_id']);
		$hasPermission = $visitor->hasPermission('general', 'associateXenPushover');

		if (!$auth || !$hasPermission)
		{
			return $this->responseNoPermission();
		}

		/** @var XenForo_Model_UserExternal $externalAuthModel */
		$externalAuthModel = $this->getModelFromCache('XenForo_Model_UserExternal');

		$input = $this->_input->filter(array(
			'account' => XenForo_Input::STRING
		));
		if ($input['account'] == 'xenpushover')
		{
			$pushoverData = $this->_input->filter(array(
				'user' => XenForo_Input::STRING,
				'device' => XenForo_Input::STRING,
				'sound' => XenForo_Input::STRING,
			));

			$optOuts = array();
			$priorities = array();

			$contentTypes = $this->_input->filterSingle('content_types', array(XenForo_Input::UINT, 'array' => true));
			$alertPriorities = $this->_input->filterSingle('alert_priority', array(XenForo_Input::INT, 'array' => true));

			foreach (array_keys($this->_input->filterSingle('contentTypesSet', array(XenForo_Input::UINT, 'array' => true))) AS $optOut)
			{
				if (empty($contentTypes[$optOut]))
				{
					$optOuts[$optOut] = $optOut;
				}
				else
				{
					$priorities[$optOut] = $alertPriorities[$optOut];
				}
			}

			/** @var $pushoverModel XenPushover_Model_Pushover */
			$pushoverModel = $this->getModelFromCache('XenPushover_Model_Pushover');

			$pushoverModel->prepareOptOuts($optOuts);
			$pushoverModel->preparePriorities($priorities);

			$pushoverData['token'] = XenForo_Application::get('options')->xenpushoverApiToken;

			if ($pushoverData['user'] === '' && $pushoverData['device'] === '')
			{
				$externalAuthModel->deleteExternalAuthAssociationForUser('xenpushover', $visitor['user_id']);

				return $this->responseRedirect(
					XenForo_ControllerResponse_Redirect::SUCCESS,
					$this->getDynamicRedirect()
				);
			}

			if ($pushoverData['user'] === '')
			{
				return $this->responseError(new XenForo_Phrase('xenpushover_you_must_enter_a_valid_user_or_group_key'));
			}



			$response = $pushoverModel->getPushoverResponse('https://api.pushover.net/1/users/validate.json', $pushoverData);
			if ($response['status'] === 0)
			{
				if (!empty($response['errors']))
				{
					$errors = implode(".\n", $response['errors']);
					$errors = ucfirst($errors);

					return $this->responseError($errors . '.');
				}
			}
			unset ($pushoverData['token']);

			$userId = XenForo_Visitor::getUserId();

			$externalAuthModel->updateExternalAuthAssociation(
				'xenpushover', $response['request'], $userId, $pushoverData
			);

			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				$this->getDynamicRedirect()
			);
		}
	}
}