<?php

class XenPushover_ControllerAdmin_Pushover extends XenForo_ControllerAdmin_Abstract
{
	protected function _preDispatch($action)
	{
		$this->assertAdminPermission('manageXenPushover');
	}

	public function actionIndex()
	{
		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildAdminLink('xenpushover/alert-types')
		);
	}

	public function actionAlertTypes()
	{
		/** @var $pushoverModel XenPushover_Model_Pushover */
		$pushoverModel = $this->getModelFromCache('XenPushover_Model_Pushover');

		$alertTypes = $pushoverModel->getAlertTypesForPushover();

		$contentTypePhrases = array();

		$totalAlertTypes = 0;
		foreach ($alertTypes AS $contentType => &$alertType)
		{
			$totalAlertTypes += count($alertType);

			$phrase = new XenForo_Phrase($pushoverModel->getFriendlyNamePhraseName($contentType));
			$contentTypePhrases[$contentType] = $phrase->render(false);

			foreach ($alertType AS $action => &$item)
			{
				$phrase = new XenForo_Phrase($pushoverModel->getFriendlyNamePhraseName($contentType, $action));
				$item['friendlyName'] = $phrase->render(false);
			}
		}

		$viewParams = array(
			'alertTypes' => $alertTypes,
			'contentTypePhrases' => $contentTypePhrases,
			'totalAlertTypes' => $totalAlertTypes
		);

		return $this->responseView(
			'XenPushover_ViewAdmin_Pushover_AlertList',
			'xenpushover_alert_types',
			$viewParams
		);
	}

	public function actionAlertTypesEdit()
	{
		$contentType = $this->_input->filterSingle('content_type', XenForo_Input::STRING);
		$action = $this->_input->filterSingle('action', XenForo_Input::STRING);

		if (!$contentType && !$action)
		{
			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildAdminLink('xenpushover/alert-types')
			);
		}

		/** @var $pushoverModel XenPushover_Model_Pushover */
		$pushoverModel = $this->getModelFromCache('XenPushover_Model_Pushover');

		$alertTypes = $pushoverModel->getAlertTypesForPushover();

		if ($action)
		{
			$friendlyName = new XenForo_Phrase($pushoverModel->getFriendlyNamePhraseName($contentType, $action));

			$viewParams = array(
				'contentType' => $contentType,
				'action' => $action,
				'alertType' => $alertTypes[$contentType][$action],
				'friendlyName' => $friendlyName->render(false)
			);
		}
		else
		{
			$friendlyName = new XenForo_Phrase($pushoverModel->getFriendlyNamePhraseName($contentType));

			$viewParams = array(
				'contentType' => $contentType,
				'alertType' => $alertTypes[$contentType],
				'friendlyName' => $friendlyName->render(false)
			);
		}

		return $this->responseView(
			'XenPushover_ViewAdmin_Pushover_AlertEdit',
			'xenpushover_alert_type_edit',
			$viewParams
		);
	}

	public function actionAlertTypesSave()
	{
		$alertType = $this->_input->filter(array(
			'content_type' => XenForo_Input::STRING,
			'action' => XenForo_Input::STRING,
			'enabled' => XenForo_Input::BOOLEAN
		));

		$dw = XenForo_DataWriter::create('XenPushover_DataWriter_AlertTypes', XenForo_DataWriter::ERROR_SILENT);
		if ($dw->setExistingData($alertType))
		{
			$friendlyName = $this->_input->filterSingle('friendly_name', XenForo_Input::STRING);
			$dw->setExtraData(XenPushover_DataWriter_AlertTypes::DATA_FRIENDLY_NAME, $friendlyName);

			$dw->bulkSet($alertType);
			$dw->save();
		}

		if (!$alertType['action'])
		{
			$friendlyName = $this->_input->filterSingle('friendly_name', XenForo_Input::STRING);
			$dw->setExtraData(XenPushover_DataWriter_AlertTypes::DATA_FRIENDLY_NAME, $friendlyName);

			$dw->setContentTypePhrase($alertType['content_type']);
		}

		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			$this->getDynamicRedirect()
		);
	}

	public function actionAlertTypesToggle()
	{
		$pushoverModel = $this->_getPushoverModel();

		return $this->_getToggleResponse(
			$pushoverModel->prepareForToggling($pushoverModel->getAllAlertTypes()),
			'XenPushover_DataWriter_AlertTypes',
			'xenpushover/alert-types',
			'enabled'
		);
	}

	public function actionAlertTypesRebuild()
	{
		$this->_getPushoverModel()->rebuildAlertTypes();

		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			$this->getDynamicRedirect()
		);
	}

	public function actionAdminAlerts()
	{
		$pushoverModel = $this->_getPushoverModel();
		$optionModel = $this->getModelFromCache('XenForo_Model_Option');

		$viewParams = array(
			'sounds' => $pushoverModel->getNotificationSounds(),
			'priorities' => $pushoverModel->getPriorityLevels(true),
			'options' => $optionModel->prepareOptions($optionModel->getOptionsByIds(array('xenpushoverAdminKey'))),
			'canEditOptionDefinition' => $optionModel->canEditOptionAndGroupDefinitions(),
			'adminAlerts' => $pushoverModel->prepareAdminAlertTypes($pushoverModel->getAllAdminAlertTypes())
		);

		return $this->responseView(
			'XenPushover_ViewAdmin_Pushover_AdminAlerts',
			'xenpushover_admin_alerts',
			$viewParams
		);
	}

	public function actionAdminAlertsSave()
	{
		$this->_assertPostOnly();

		$input = $this->_input->filter(array(
			'group_id' => XenForo_Input::STRING,
			'options' => XenForo_Input::ARRAY_SIMPLE,
			'options_listed' => array(XenForo_Input::STRING, array('array' => true))
		));

		foreach ($input['options_listed'] AS $optionName)
		{
			if (!isset($input['options'][$optionName]))
			{
				$input['options'][$optionName] = '';
			}
		}

		$optionModel = $this->getModelFromCache('XenForo_Model_Option');
		$optionModel->updateOptions($input['options']);

		$pushoverModel = $this->_getPushoverModel();

		$adminAlerts = $this->_input->filterSingle('admin_alerts', XenForo_Input::ARRAY_SIMPLE);
		$adminAlertsShown = $this->_input->filterSingle('adminAlertsShown', XenForo_Input::ARRAY_SIMPLE);

		foreach ($adminAlertsShown AS $alertType => $adminAlert)
		{
			$dw = XenForo_DataWriter::create('XenPushover_DataWriter_AdminAlerts');
			$dw->setExistingData($alertType, true);

			if (!isset($adminAlerts[$alertType]))
			{
				$dw->set('enabled', 0);
			}
			else
			{
				$adminAlert = $adminAlerts[$alertType];
				$adminAlert['priority'] = $pushoverModel->getPriorityFromId($adminAlert['priority']);

				$dw->bulkSet($adminAlert);
			}

			$dw->save();
		}

		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildAdminLink('xenpushover/admin-alerts')
		);
	}

	public function actionXenforo()
	{
		$visitor = XenForo_Visitor::getInstance();

		$auth = $this->getModelFromCache('XenForo_Model_User')->getUserAuthenticationObjectByUserId($visitor['user_id']);
		if (!$auth)
		{
			return $this->responseNoPermission();
		}

		/** @var XenForo_Model_UserExternal $externalAuthModel */
		$externalAuthModel = $this->getModelFromCache('XenForo_Model_UserExternal');

		$external = $externalAuthModel->getExternalAuthAssociationsForUser($visitor['user_id']);

		if (!empty($external['xenpushoverScrape']))
		{
			$external['xenpushoverScrape']['extra_data'] = @unserialize($external['xenpushoverScrape']['extra_data']);
		}

		$pushoverModel = $this->_getPushoverModel();

		$viewParams = array(
			'external' => $external,
			'sounds' => $pushoverModel->getNotificationSounds(),
			'priorities' => $pushoverModel->getPriorityLevels()
		);

		return $this->responseView('XenPushover_ViewAdmin_Pushover_XenForo', 'xenpushover_xenforo_setup', $viewParams);
	}

	public function actionXenforoSave()
	{
		$this->_assertPostOnly();

		$visitor = XenForo_Visitor::getInstance();

		$auth = $this->getModelFromCache('XenForo_Model_User')->getUserAuthenticationObjectByUserId($visitor['user_id']);

		if (!$auth)
		{
			return $this->responseNoPermission();
		}

		/** @var XenForo_Model_UserExternal $externalAuthModel */
		$externalAuthModel = $this->getModelFromCache('XenForo_Model_UserExternal');

		$input = $this->_input->filter(array(
			'account' => XenForo_Input::STRING
		));
		if ($input['account'] == 'xenpushoverScrape')
		{
			$pushoverData = $this->_input->filter(array(
				'user' => XenForo_Input::STRING,
				'device' => XenForo_Input::STRING,
				'sound' => XenForo_Input::STRING,
				'priority' => XenForo_Input::INT,
				'nick' => XenForo_Input::STRING,
				'token' => XenForo_Input::STRING,
				'username' => XenForo_Input::STRING,
				'password' => XenForo_Input::STRING
			));
			$pushoverData['url'] = 'http://xenforo.com/community/';

			if ($pushoverData['user'] === '' && $pushoverData['device'] === ''
				&& $pushoverData['token'] === '' && $pushoverData['username'] === ''
				&& $pushoverData['password'] === ''
			)
			{
				$externalAuthModel->deleteExternalAuthAssociationForUser('xenpushoverScrape', $visitor['user_id']);

				return $this->responseRedirect(
					XenForo_ControllerResponse_Redirect::SUCCESS,
					$this->getDynamicRedirect()
				);
			}
			if (!$pushoverData['token'])
			{
				$pushoverData['token'] = XenForo_Application::getOptions()->xenpushoverApiToken;
			}

			if ($pushoverData['user'] === '')
			{
				return $this->responseError(new XenForo_Phrase('xenpushover_you_must_enter_a_valid_user_or_group_key'));
			}

			/** @var $pushoverModel XenPushover_Model_Pushover */
			$pushoverModel = $this->getModelFromCache('XenPushover_Model_Pushover');

			$response = $pushoverModel->getPushoverResponse('https://api.pushover.net/1/users/validate.json', $pushoverData);
			if ($response['status'] === 0)
			{
				if (!empty($response['errors']))
				{
					$errors = implode(".\n", $response['errors']);
					$errors = ucfirst($errors);

					return $this->responseError($errors . '.');
				}
			}

			$url = rtrim($pushoverData['url'], '/');
			if (strpos($url, 'index.php'))
			{
				$url .= '?';
			}
			else
			{
				$url .= '/';
			}
			$loginUrl = $url . 'login/login';

			$client = XenForo_Helper_Http::getClient($loginUrl);
			$client->setParameterPost(array(
				'login' => $pushoverData['username'],
				'password' => $pushoverData['password']
			));
			$client->setCookieJar();
			$client->setHeaders('X-Requested-With', 'XMLHttpRequest');

			$request = $client->request(Zend_Http_Client::POST);
			$result = $request->getBody();

			$dom = new Zend_Dom_Query($result);

			$LoggedIn = $dom->query('html.LoggedIn');
			if ($LoggedIn->count() === 0)
			{
				$errors = $dom->query('span.errors');
				if ($errors->count() > 0)
				{
					return $this->responseError($errors->current()->textContent);
				}
				else
				{
					return $this->responseError(new XenForo_Phrase('xenpushover_error_logging_in_to_site'));
				}
			}

			$alertsUrl = $url . 'account/alerts';

			$client->setUri($alertsUrl);
			$client->setHeaders('X-Requested-With', 'XMLHttpRequest');

			$request = $client->request(Zend_Http_Client::GET);
			$result = $request->getBody();

			$dom = new Zend_Dom_Query($result);

			$alertsList = $dom->query('ol.alerts ol');
			$alertItems = $alertsList->current()->getElementsByTagName('li');

			$alerts = array();
			foreach ($alertItems AS $alertItem)
			{
				$id = str_replace('alert', '', $alertItem->getAttribute('id'));
				$alerts[intval($id)] = $alertsList->current()->ownerDocument->saveXML($alertItem);
			}
			krsort($alerts, SORT_NUMERIC);
			$pushoverData['alerts'] = $alerts;

			$userId = XenForo_Visitor::getUserId();
			$externalAuthModel->updateExternalAuthAssociation(
				'xenpushoverScrape', $response['request'], $userId, $pushoverData
			);

			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				$this->getDynamicRedirect()
			);
		}
	}

	/**
	 * @return XenPushover_Model_Pushover
	 */
	protected function _getPushoverModel()
	{
		return $this->getModelFromCache('XenPushover_Model_Pushover');
	}
}