<?php

class XenES_Install
{
	public static function install($previous)
	{
		if (XenForo_Application::$versionId < 1030070)
		{
			throw new XenForo_Exception('XenForo Enhanced Search requires XenForo 1.3.0 or newer.', true);
		}

		$db = XenForo_Application::get('db');

		if (!$previous || $previous['version_id'] < 1010010)
		{
			foreach (self::getTables() AS $tableSql)
			{
				try
				{
					$db->query($tableSql);
				}
				catch (Zend_Db_Exception $e) {}
			}
		}
	}

	public static function uninstall()
	{
		$db = XenForo_Application::get('db');

		foreach (self::getTables() AS $tableName => $tableSql)
		{
			try
			{
				$db->query("DROP TABLE IF EXISTS `$tableName`");
			}
			catch (Zend_Db_Exception $e) {}
		}
	}

	public static function getTables()
	{
		$tables = array();

		$tables['xf_es_search_failed'] = "
			CREATE TABLE `xf_es_search_failed` (
				`search_failed_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
				`content_type` varbinary(25) NOT NULL,
				`content_id` int(10) unsigned NOT NULL,
				`action` varchar(25) NOT NULL,
				`data` mediumblob NOT NULL,
				`fail_count` smallint(5) unsigned NOT NULL DEFAULT '0',
				`reindex_date` int(11) NOT NULL DEFAULT '0',
				PRIMARY KEY (`search_failed_id`),
				UNIQUE KEY `content_type` (`content_type`,`content_id`),
				KEY `reindex_date` (`reindex_date`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8
		";

		return $tables;
	}
}