<?php

class XenES_ControllerAdmin_Elasticsearch extends XenForo_ControllerAdmin_Abstract
{
	public function actionIndex()
	{
		$esApi = XenES_Api::getInstance();
		$esModel = $this->_getEsModel();

		$esVersion = $esApi->version();
		if ($esVersion)
		{
			$stats = $esModel->getStats();
			$stemmingConfig = $esModel->getStemmingConfiguration();
			$hasOptimizable = count($esModel->getOptimizableMappings()) > 0;
		}
		else
		{
			$stats = false;
			$stemmingConfig = false;
			$hasOptimizable = false;
		}

		$viewParams = array(
			'esServer' => $esApi->getServer(),
			'esIndex' => $esApi->getIndex(),
			'esVersion' => $esVersion,
			'stats' => $stats,
			'stemmingConfig' => $stemmingConfig,
			'hasOptimizable' => $hasOptimizable,
			'isSuperAdmin' => XenForo_Visitor::getInstance()->isSuperAdmin(),
			'success' => $this->_input->filterSingle('success', XenForo_Input::UINT)
		);

		return $this->responseView('XenES_ViewAdmin_Elasticsearch', 'elasticsearch_index', $viewParams);
	}

	public function actionUpdate()
	{
		$this->_assertPostOnly();

		$input = $this->_input->filter(array(
			'analyzer' => XenForo_Input::STRING,
			'stemming_language' => XenForo_Input::STRING
		));
		if (!$input['stemming_language'])
		{
			$input['stemming_language'] = 'English';
		}

		$indexName = XenES_Api::getInstance()->getIndex();
		$esModel = $this->_getEsModel();
		$success = false;

		if ($input['analyzer'])
		{
			switch ($input['analyzer'])
			{
				case 'snowball': $analyzer = array('type' => 'snowball', 'language' => $input['stemming_language']); break;
				case 'standard': $analyzer = array('type' => 'standard'); break;
				default: $analyzer = false;
			}

			if ($analyzer)
			{
				$dsl = array();
				$dsl['index']['analysis']['analyzer']['default'] = $analyzer;

				$closeRes = XenES_Api::closeIndex($indexName);
				if (!empty($closeRes->status) && $closeRes->status == 404)
				{
					// need to create
					XenES_Api::createIndex($indexName, array('settings' => $dsl));
				}
				else
				{
					XenES_Api::updateSettings($indexName, $dsl);
					XenES_Api::openIndex($indexName);
				}

				$success = true;
			}
		}

		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildAdminLink('elasticsearch', null, array('success' => $success))
		);
	}

	public function actionOptimizeMapping()
	{
		$this->_assertPostOnly();

		$esModel = $this->_getEsModel();
		$indexName = XenES_Api::getInstance()->getIndex();

		$mappings = $esModel->getMappings();
		if ($mappings === false)
		{
			XenES_Api::createIndex($indexName);
			$mappings = new StdClass();
		}

		foreach ($esModel->getOptimizableMappings() AS $type)
		{
			$esModel->optimizeMapping($type, isset($mappings->$type));
		}

		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildAdminLink('elasticsearch', null, array('success' => 1))
		);
	}

	public function actionDeleteIndex()
	{
		$this->_assertPostOnly();
		$this->assertSuperAdmin();

		$success = false;

		if ($this->_input->filterSingle('confirm', XenForo_Input::UINT))
		{
			$this->_getEsModel()->recreateIndex();
		}

		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildAdminLink('elasticsearch', null, array('success' => $success))
		);
	}

	/**
	 * @return XenES_Model_Elasticsearch
	 */
	protected function _getEsModel()
	{
		return $this->getModelFromCache('XenES_Model_Elasticsearch');
	}
}