<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/
 
class XenCentral_PaymentApi_Module
{
    protected static $instance;

    protected function __construct()
    {

    }

    /**
     * @var Zend_Controller_Request_Http
     */
    protected $_request;

    /**
     * @return XenCentral_PaymentApi_Module
     */
    public static function getInstance()
    {
        if(is_null(self::$instance)) {
            self::$instance=new self();
        }
        return self::$instance;
    }

	protected $_version='1.0.0';
	
	protected $_moduleId='PaymentApi';
	
	/**
	 * Array containing registered methods
	 * @var array
	 */
	protected $_methods;

    /**
     * @static
     * Should return unique string-only ID for the module
     * @return String
     */
    public static function getModuleId()
    {
        return 'PaymentApi';
    }
	
	public function install()
	{
        $this->getDb()->query("
			CREATE TABLE IF NOT EXISTS xcfw_paymentapi_manual_transaction (
					`txn_id` VARCHAR( 32 ) NOT NULL PRIMARY KEY,
					`transaction_hash` VARCHAR( 32 ) NOT NULL,
					`user_id` INT( 11 ) UNSIGNED NOT NULL,
					`purchase_handler` VARCHAR( 255 ) NOT NULL,
					`request` MEDIUMBLOB NOT NULL,
					`dateline` INT NOT NULL
				) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci;
		");

		$this->getDb()->query("
			CREATE TABLE IF NOT EXISTS ".$this->getTransactionTableName()." (
					`id` INT( 11 ) UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
					`transactionhash` VARCHAR( 32 ) NOT NULL,
					`method` VARCHAR( 255 ) NOT NULL,
					`initinfo` TEXT NOT NULL,
					`dateline` INT NOT NULL
				) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci;
		");
		
		$this->getDb()->query("
			CREATE TABLE IF NOT EXISTS ".$this->getTransactionLogTableName()." (
					`infoid` INT( 11 ) UNSIGNED NOT NULL,
					`transactionid` VARCHAR( 255 ) NOT NULL ,
					`request` TEXT NOT NULL,
					`status` varchar(255) NOT NULL,
					`dateline` INT NOT NULL,
					PRIMARY KEY (`infoid`, `transactionid`)
				) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci;
		");
		
		$this->getDb()->query("
			CREATE TABLE IF NOT EXISTS ".$this->getErrorLogTableName()." (
					`id` INT( 11 ) UNSIGNED NOT NULL AUTO_INCREMENT,
					`infoid` INT(11) UNSIGNED NOT NULL,
					`error_code` VARCHAR( 255 ) NOT NULL ,
					`error_message` VARCHAR( 255 ) NOT NULL ,
					`request` TEXT NOT NULL,
					`dateline` INT NOT NULL,
					PRIMARY KEY (`id`)
				) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci;
		");

        $db=$this->getDb();

        // fix for database table collations
        $currentCollation = $db->fetchRow("
            SHOW TABLE STATUS WHERE Name =  ?
        ", array($this->getTransactionTableName()));
        if ($currentCollation['Collation'] != 'utf8_general_ci') {
            $tableList = $db->fetchAll('SHOW TABLES LIKE  \'xcfw_%\'');
            foreach ($tableList AS $tableName) {
                $tableName = reset($tableName);
                $db->query('ALTER TABLE ' . $tableName . ' CONVERT TO CHARACTER SET utf8 COLLATE utf8_general_ci');
            }
        }

        $transaction=$db->fetchOne('
            SHOW INDEX FROM '.$this->getTransactionTableName().'
            WHERE Key_name=\'transactionhash\'
        ');

        if(!$transaction) {
            $db->query('
                ALTER TABLE '.$this->getTransactionTableName().'
                ADD INDEX transactionhash (transactionhash)
            ');
        }
	}

    public function uninstall()
	{
		// 
		
		$this->getDb()->query("
			DROP TABLE IF EXISTS ".$this->getTransactionTableName()."
		");
		
		$this->getDb()->query("
			DROP TABLE IF EXISTS ".$this->getTransactionLogTableName()."
		");
		
		$this->getDb()->query("
			DROP TABLE IF EXISTS ".$this->getErrorLogTableName()."
		");
	}

    public function setRequest($request)
    {
        $this->_request = $request;
    }

    public function getRequest()
    {
        if(is_null($this->_request)) {
            $this->_request=new Zend_Controller_Request_Http();
        }
        return $this->_request;
    }

    /**
     * Returns payment method object
     * @param string $methodName
     * @throws Exception
     * @return XenCentral_PaymentApi_Method
     */
	public function getMethod($methodName)
	{
        if (isset($this->_methods[$methodName]))
		{
			return $this->_methods[$methodName];
		}
		
		$className="XenCentral_PaymentApi_Methods_$methodName";
		
		if (!class_exists($className))
		{
			throw new Exception("Payment method not could not be loaded - $className.");
		}
		
		if(!is_subclass_of($className, 'XenCentral_PaymentApi_Method'))
		{
			throw new Exception("Payment method should extend class <i>PaymentApi_Method</i>");
		}
		
		$this->_methods[$methodName]=new $className($this);
		
		return $this->_methods[$methodName];
	}
	
	/**
	 * Logs error to the database based on error information in payment method array
	 * @param XenCentral_PaymentApi_Method $paymentMethod
	 */
	public function logError($paymentMethod)
	{
		$transaction=$paymentMethod->getTransaction();
		$errors=$paymentMethod->getErrors();
		$error=array(
			'infoid'=>empty($transaction['id'])?0: $transaction['id'],
			'error_code'=>serialize(array_keys($errors)),
			'error_message'=>serialize(array_values($errors)),
			'request'=>serialize(array('get'=>$_GET, 'post'=>$_POST, 'cookie'=>$_COOKIE, 'server'=>$_SERVER)),
			'dateline'=>time()
		);
		
		$this->getDb()->insert($this->getErrorLogTableName(), $error);
	}

    public function getTransactionInfo($transaction_id)
    {
        $transaction=$this->getDb()->fetchRow("
            SELECT * FROM ".$this->getTransactionTableName()."
            WHERE id=".intval($transaction_id)."
        ");

        if(!$transaction) {
            return false;
        }

        $transaction['initinfo'] = unserialize($transaction['initinfo']);

        return $transaction;
    }
	
	public function getTransactionTableName()
	{
		return $this->getTablePrefix()."xcfw_paymentapi_transaction";  
	}
	
	public function getTransactionLogTableName()
	{
		return $this->getTablePrefix()."xcfw_paymentapi_transactionlog";  
	}
	
	public function getErrorLogTableName()
	{
		return $this->getTablePrefix()."xcfw_paymentapi_errorlog";
	}

    public function getDb()
    {
        return XenForo_Application::getDb();
    }

    public function getTablePrefix()
    {
        return '';
    }
    
}