<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/

class XenCentral_PaymentApi_Methods_Plimus extends XenCentral_PaymentApi_Method
{
	protected $_validSettings=array (
			'protectionKey' => array (
					'title' => 'Data Protection Key', 
					'required' => 1 
			) 
	);
	
	protected $_validFields=array (
			'contractid' => array (
					'title' => 'Contract ID', 
					'required' => 0 
			), 
			'overridePrice' => array (
					'title' => 'Override Price', 
					'required' => 1 
			), 
			'currency' => array (
					'title' => 'Currency', 
					'required' => 0, 
					'default' => 'USD' 
			), 
			'quantity' => array (
					'title' => 'Quantity', 
					'required' => 0, 
					'default' => 1 
			) 
	);
	
	protected function _generateTransactionHash()
	{
		return md5($this->_info['invoiceid'] . $this->_info['contractid'] . $this->_info['overridePrice'] . rand(1, time()));
	}
	
	protected function _validateSettings()
	{
		if(!$this->_settings['protectionKey'])
		{
			$this->_setError('protection_key', "Please fill Plimus data protection key.");
			return false;
		}
		return parent::_validateSettings();
	}
	
	protected function _validateInfo()
	{
		if(!$this->_info['contractid'])
		{
			$this->_setError('contractid', "Plimus requires contractid to be specified");
			return false;
		}
		
		return parent::_validateInfo();
	}
	
	protected function _getDebugFormURL()
	{
		return 'http://sandbox.plimus.com/jsp/buynow.jsp';
	}
	
	protected function _getLiveFormURL()
	{
		return 'https://secure.plimus.com/jsp/buynow.jsp';
	}
	
	protected function _getFormMethod()
	{
		return 'GET';
	}
	
	protected function _getFormHiddenFields()
	{
		$this->_info['referrer']=$this->_info['transactionhash']=$this->_info['custom1']=$this->_additionalInfo['transactionhash'];
		
		return XenCentral_Framework_Helper_Html::constructHiddenCode($this->_info);
	}
	
	public function getMethodIdentifier($formatted=false)
	{
		if($formatted)
		{
			return 'Plimus';
		}
		
		return 'plimus';
	}
	
	protected function _getTransactionHashFromRequest()
	{
		if ($this->getApi()->getRequest()->getParam('custom1'))
		{
			$hash=$this->getApi()->getRequest()->getParam('custom1');
		}
		else if ($this->getApi()->getRequest()->getParam('transactionhash'))
		{
			$hash=$this->getApi()->getRequest()->getParam('transactionhash');
		}
		else
		{
			$hash=$this->getApi()->getRequest()->getParam('referrer');
		}
		
		return $this->_validatePaymentHash($hash);
	}
	
	protected function _validateRequest()
	{
		$settings=$this->getSettings();
		
		if($this->getApi()->getRequest()->getParam('authKey') !== md5($this->getApi()->getRequest()->getParam('referenceNumber') . $this->getApi()->getRequest()->getParam('contractId') . $settings['protectionKey']))
		{
			$this->_setError('authentication_error', "Could not authenticate the request.");
			return false;
		}
		
		return true;
	}
	
	public function sendSuccessResponse()
	{
		echo md5('OK' + $this->getSettings('protectionKey'));
	}
	
	protected function _setTransactionIdFromRequest()
	{
		$this->setTransactionId($this->getApi()->getRequest()->getParam('referenceNumber'));
	}
	
	protected function _setTypeFromRequest()
	{
		if($this->getApi()->getRequest()->getParam('transactionType') == 'CHARGE')
		{
			$this->setType('payment');
		}
		else if(in_array($this->getApi()->getRequest()->getParam('transactionType'), array (
				'REFUND', 
				'CHARGEBACK', 
				'CANCELLATION', 
				'CANCELLATION_REFUND', 
				'CANCELLATION_CHARGEBACK' 
		)))
		{
			$this->setType('refund');
		}
		else
		{
			$this->setType('Unknow transaction type');
		}
	}

    /**
     * Data Protection Key
     * @Required
     */
    function setSettingProtectionKey($value)
    {
        $this->setSetting('protectionKey', $value);
    }

    /**
     * Contract ID
     */
    function setFieldContractid($value)
    {
        $this->setField('contractid', $value);
    }

    /**
     * Override Price
     * @Required
     */
    function setFieldOverridePrice($value)
    {
        $this->setField('overridePrice', $value);
    }

    /**
     * Currency
     * @default USD
     */
    function setFieldCurrency($value)
    {
        $this->setField('currency', $value);
    }

    /**
     * Quantity
     * @default 1
     */
    function setFieldQuantity($value)
    {
        $this->setField('quantity', $value);
    }
}