<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/

class XenCentral_PaymentApi_Methods_MoneyBookers extends XenCentral_PaymentApi_Method
{
    protected $_validSettings = array(
        'moneybookers_secret' => array(
            'title' => 'MoneyBookers Secret',
            'required' => 1
        ),
        'pay_to_email' => array(
            'title' => 'Merchant Email',
            'required' => 1,
            'field' => 1
        )
    );

    protected $_validFields = array(
        'pay_to_email' => array(
            'title' => 'Merchant Email',
            'required' => 1,
            'default' => ''
        ),
        'pay_from_email' => array(
            'title' => 'Buyer Email',
            'required' => 0,
            'default' => ''
        ),
        'recipient_description' => array(
            'title' => 'Description',
            'required' => 0,
            'default' => ''
        ),
        'transaction_id' => array(
            'title' => 'Transaction ID',
            'required' => 0,
            'default' => ''
        ),
        'status_url' => array(
            'title' => 'Status URL',
            'required' => 1,
            'default' => ''
        ),
        'cancel_url' => array(
            'title' => 'Cancel URL',
            'required' => 1,
            'default' => ''
        ),
        'return_url' => array(
            'title' => 'Return URL',
            'required' => 1,
            'default' => ''
        ),
        'firstname' => array(
            'title' => 'First Name',
            'required' => 0,
            'default' => ''
        ),
        'lastname' => array(
            'title' => 'Last Name',
            'required' => 0,
            'default' => ''
        ),

        'currency' => array(
            'title' => 'Currency',
            'required' => 0,
            'default' => 'USD'
        ),
        'amount' => array(
            'title' => 'Payment Amount',
            'required' => 1,
            'default' => ''
        ),
        'language' => array(
            'title' => 'Language',
            'required' => 0,
            'default' => 'EN'
        ),
        'merchant_fields' => array(
            'title' => 'Merchant Fields',
            'required' => 0,
            'default' => 'transactionhash'
        ),
        'transactionhash' => array(
            'title' => 'Transaction Hash',
            'required' => 0,
            'default' => ''
        ),
        'detail1_text' => array(
            'title' => 'Details',
            'required' => 0,
            'default' => ''
        )
    );

    protected function _generateTransactionHash()
    {
        return md5($this->_info['merchant_id'] . rand(1, time()));
    }

    protected function _validateSettings()
    {
        if (!$this->_settings['moneybookers_secret']) {
            $this->_setError('moneybookers_secret', "Please fill MoneyBookers secret word.");
            return false;
        }

        return parent::_validateSettings();
    }

    protected function _validateInfo()
    {
        if (!$this->_info['currency']) {
            $this->_setError('currency', "It is required to specify the currency.");
            return false;
        }

        return parent::_validateInfo();
    }

    protected function _getDebugFormURL()
    {
        return 'https://www.moneybookers.com/app/payment.pl?p=SkyDevPaymentModule';
    }

    protected function _getLiveFormURL()
    {
        return 'https://www.moneybookers.com/app/payment.pl?p=SkyDevPaymentModule';
    }

    protected function _getFormMethod()
    {
        return 'POST';
    }

    protected function _getFormHiddenFields()
    {
        $this->_info['transactionhash']= $this->_info['transaction_id'] = $this->_additionalInfo['transactionhash'];

        return XenCentral_Framework_Helper_Html::constructHiddenCode($this->_info);
    }

    public function getMethodIdentifier($formatted = false)
    {
        if ($formatted) {
            return 'MoneyBookers';
        }

        return 'moneybookers';
    }

    protected function _getTransactionHashFromRequest()
    {
        if ($this->getApi()->getRequest()->getParam('transactionhash')) {
            $hash = $this->getApi()->getRequest()->getParam('transactionhash');
        } else if ($this->getApi()->getRequest()->getParam('order_id')) {
            $hash = $this->getApi()->getRequest()->getParam('order_id');
        } else {
            $hash = '';
        }
        return $this->_validatePaymentHash($hash);
    }

    protected function _validateRequest()
    {
        $settings = $this->getSettings();

        $hash = $_POST['merchant_id'];
        $hash .= $_POST['transaction_id'];
        $hash .= strtoupper(md5(isset($settings['moneybookers_secret']) ? $settings['moneybookers_secret'] : 'none'));
        $hash .= $_POST['mb_amount'];
        $hash .= $_POST['mb_currency'];
        $hash .= $_POST['status'];

        $md5hash = strtoupper(md5($hash));
        $md5sig = $_POST['md5sig'];

        if ($md5hash == $md5sig) {
            if ($_POST['status'] == '2') {
                return true;
            } else {
                $this->_setError('authentication_error', "Payment status is unknown.");
            }
        } else {
            $this->_setError('authentication_error', "Could not authenticate the request.");
        }

        return false;
    }

    public function sendSuccessResponse()
    {

    }

    protected function _setTransactionIdFromRequest()
    {
        $this->setTransactionId($this->getApi()->getRequest()->getParam('transaction_id'));
    }

    protected function _setTypeFromRequest()
    {
        if ($_POST['status'] == '2') {
            $this->setType('payment');
        } else {
            $this->setType('Unknow transaction type');
        }
    }

    /**
     * MoneyBookers Secret
     * @Required
     */
    function setSettingMoneybookersSecret($value)
    {
        $this->setSetting('moneybookers_secret', $value);
    }

    /**
     * Merchant Email
     * @Required
     */
    function setSettingPayToEmail($value)
    {
        $this->setSetting('pay_to_email', $value);
    }

    /**
     * Buyer Email
     */
    function setFieldPayFromEmail($value)
    {
        $this->setField('pay_from_email', $value);
    }

    /**
     * Description
     */
    function setFieldRecipientDescription($value)
    {
        $this->setField('recipient_description', $value);
    }

    /**
     * Transaction ID
     */
    function setFieldTransactionId($value)
    {
        $this->setField('transaction_id', $value);
    }

    /**
     * Status URL
     * @Required
     */
    function setFieldStatusUrl($value)
    {
        $this->setField('status_url', $value);
    }

    /**
     * Cancel URL
     * @Required
     */
    function setFieldCancelUrl($value)
    {
        $this->setField('cancel_url', $value);
    }

    /**
     * Return URL
     * @Required
     */
    function setFieldReturnUrl($value)
    {
        $this->setField('return_url', $value);
    }

    /**
     * First Name
     */
    function setFieldFirstname($value)
    {
        $this->setField('firstname', $value);
    }

    /**
     * Last Name
     */
    function setFieldLastname($value)
    {
        $this->setField('lastname', $value);
    }

    /**
     * Currency
     * @default USD
     */
    function setFieldCurrency($value)
    {
        $this->setField('currency', $value);
    }

    /**
     * Payment Amount
     * @Required
     */
    function setFieldAmount($value)
    {
        $this->setField('amount', $value);
    }

    /**
     * Language
     * @default EN
     */
    function setFieldLanguage($value)
    {
        $this->setField('language', $value);
    }

    /**
     * Merchant Fields
     * @default transactionhash
     */
    function setFieldMerchantFields($value)
    {
        $this->setField('merchant_fields', $value);
    }

    /**
     * Transaction Hash
     */
    function setFieldTransactionhash($value)
    {
        $this->setField('transactionhash', $value);
    }

    /**
     * Details
     */
    function setFieldDetail1Text($value)
    {
        $this->setField('detail1_text', $value);
    }
}