<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/

class XenCentral_PaymentApi_Methods_Authorize extends XenCentral_PaymentApi_Method
{
	protected $_responseRequired=true;
	
	protected $_validSettings=array (
			'x_login' => array (
					'title' => 'Authorize.Net Login', 
					'required' => 1, 
					'field' => 1 
			), 
			'txnkey' => array (
					'title' => 'Transaction Key', 
					'required' => 1 
			), 
			'secret' => array (
					'title' => 'Secret Key', 
					'required' => 0 
			) 
	);
	
	protected $_validFields=array (
			'x_description' => array (
					'title' => 'Description', 
					'required' => 0 
			), 
			'x_amount' => array (
					'title' => 'Amount', 
					'required' => 1 
			), 
			'x_relay_url' => array (
					'title' => 'IPN URL', 
					'required' => 1 
			), 
			'x_show_form' => array (
					'title' => 'Form Type', 
					'required' => 0, 
					'default' => 'PAYMENT_FORM' 
			), 
			'x_relay_response' => array (
					'title' => 'Return Response', 
					'required' => 0, 
					'default' => 'TRUE' 
			), 
			'x_test_request' => array (
					'title' => 'Test Mode', 
					'required' => 0 
			), 
			'x_currency_code' => array (
					'title' => 'Currency', 
					'required' => 0, 
					'default' => 'USD' 
			), 
			'x_type' => array (
					'title' => 'Type', 
					'required' => 0, 
					'default' => 'AUTH_CAPTURE' 
			), 
			'x_method' => array (
					'title' => 'Method', 
					'required' => 0, 
					'default' => 'CC' 
			), 
			'x_receipt_link_url' => array (
					'title' => 'Return URL', 
					'required' => 0 
			) 
	);
	
	protected function _generateTransactionHash()
	{
		return md5($this->_info['x_amount'] . $this->_info['x_invoice_num'] . $this->_info['x_description'] . rand(1, time()));
	}
	
	protected function _validateInfo()
	{
		if(!parent::_validateInfo())
		{
			return false;
		}
		
		$this->_info['x_fp_sequence']=rand('1', '500');
		
		$this->_info['x_fp_timestamp']=time();
		
		$data=$this->_info['x_login'] . '^' . $this->_info['x_fp_sequence'] . '^' . $this->_info['x_fp_timestamp'] . '^' . $this->_info['x_amount'] . '^' . $this->_info['x_currency_code'];
		
		$this->_info['x_fp_hash']=$this->hmac($this->getSetting('txnkey'), $data);
		
		return true;
	}
	
	protected function _getDebugFormURL()
	{
		return 'https://test.authorize.net/gateway/transact.dll';
	}
	
	protected function _getLiveFormURL()
	{
		return 'https://secure.authorize.net/gateway/transact.dll';
	}
	
	protected function _getFormMethod()
	{
		return 'POST';
	}
	
	protected function _getFormHiddenFields()
	{
		$this->_info['x_description']=$this->_info['x_description'] . ' ' . $this->_additionalInfo['transactionhash'];
		
		return XenCentral_Framework_Helper_Html::constructHiddenCode($this->_info);
	}
	
	public function getMethodIdentifier($formatted=false)
	{
		if($formatted)
		{
			return 'Authorize.NET';
		}
		
		return 'authorize';
	}
	
	protected function _getTransactionHashFromRequest()
	{
		preg_match('#^.*?\s([^\s]+)$#', $this->getApi()->getRequest()->getParam('x_description'), $hash);
		
		return $this->_validatePaymentHash($hash[1]);
	}
	
	protected function _validateRequest()
	{
		$hash=md5($this->getSetting('secret') . $this->getSetting('x_login') . $_POST['x_trans_id'] . $_POST['x_amount']);
		
		if($this->getApi()->getRequest()->getParam('x_MD5_Hash') !== strtoupper($hash))
		{
			$this->_setError('authentication_error', "Could not authenticate the request.");
			return false;
		}
		
		return true;
	}
	
	public function sendSuccessResponse()
	{
	
	}
	
	protected function _setTransactionIdFromRequest()
	{
		if($this->getDebugMode() && !$this->getApi()->getRequest()->getParam('x_trans_id'))
		{
			$this->getApi()->getRequest()->getParam('x_trans_id')=uniqid('auth_');
		}
		
		$this->setTransactionId($this->getApi()->getRequest()->getParam('x_trans_id'));
	}
	
	protected function _setTypeFromRequest()
	{
		if($this->getApi()->getRequest()->getParam('x_response_code') == 1)
		{
			$this->setType('payment');
		}
		else if(false)
		{
			$this->setType('refund');
		}
		else
		{
			$this->setType('Unknow transaction type');
		}
	}
	
	/**
	 * RFC 2104 HMAC
	 *
	 * @param	string		Key to hash data with
	 * @param	string		Data
	 *
	 * @return	string		MD5 HMAC
	 */
	private function hmac($key, $data)
	{
		$b=64;
		if(strlen($key) > $b)
		{
			$key=pack("H*", md5($key));
		}
		$key=str_pad($key, $b, chr(0x00));
		$ipad=str_pad('', $b, chr(0x36));
		$opad=str_pad('', $b, chr(0x5c));
		$k_ipad=$key ^ $ipad;
		$k_opad=$key ^ $opad;
		
		return md5($k_opad . pack("H*", md5($k_ipad . $data)));
	}
	
	public function setDebugMode($_debugMode)
	{
		if($_debugMode)
		{
			$this->setField('x_test_request', 'TRUE');
		}
		else if($this->getDebugMode())
		{
			$this->setField('x_test_request', 'FALSE');
		}
		
		return parent::setDebugMode($_debugMode);
	}
	
	public function setField($key, $value)
	{
		if($key == 'x_amount')
		{
			$value=number_format($value, 2);
		}
		
		return parent::setField($key, $value);
	}

    /**
     * Authorize.Net Login
     * @Required
     * @isField
     */
    function setSettingXLogin($value)
    {
        $this->setSetting('x_login', $value);
    }

    /**
     * Transaction Key
     * @Required
     */
    function setSettingTxnkey($value)
    {
        $this->setSetting('txnkey', $value);
    }

    /**
     * Secret Key
     */
    function setSettingSecret($value)
    {
        $this->setSetting('secret', $value);
    }

    /**
     * Description
     */
    function setFieldXDescription($value)
    {
        $this->setField('x_description', $value);
    }

    /**
     * Amount
     * @Required
     */
    function setFieldXAmount($value)
    {
        $this->setField('x_amount', $value);
    }

    /**
     * IPN URL
     * @Required
     */
    function setFieldXRelayUrl($value)
    {
        $this->setField('x_relay_url', $value);
    }

    /**
     * Form Type
     * @default PAYMENT_FORM
     */
    function setFieldXShowForm($value)
    {
        $this->setField('x_show_form', $value);
    }

    /**
     * Return Response
     * @default TRUE
     */
    function setFieldXRelayResponse($value)
    {
        $this->setField('x_relay_response', $value);
    }

    /**
     * Test Mode
     */
    function setFieldXTestRequest($value)
    {
        $this->setField('x_test_request', $value);
    }

    /**
     * Currency
     * @default USD
     */
    function setFieldXCurrencyCode($value)
    {
        $this->setField('x_currency_code', $value);
    }

    /**
     * Type
     * @default AUTH_CAPTURE
     */
    function setFieldXType($value)
    {
        $this->setField('x_type', $value);
    }

    /**
     * Method
     * @default CC
     */
    function setFieldXMethod($value)
    {
        $this->setField('x_method', $value);
    }

    /**
     * Return URL
     */
    function setFieldXReceiptLinkUrl($value)
    {
        $this->setField('x_receipt_link_url', $value);
    }
}