<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/

class XenCentral_PaymentApi_Methods_Alertpay extends XenCentral_PaymentApi_Method
{
	protected $_responseRequired=true;
	
	protected $_validSettings=array (
			'ap_merchant' => array (
					'title' => 'Merchant E-mail Address', 
					'required' => 1, 
					'field' => 1 
			), 
			'ap_securitycode' => array(
				'title'=>'Security Code',
				'required'=>1
			)
	);
	
	protected $_validFields=array (
			'ap_alerturl' => array (
					'title' => 'IPN URL', 
					'required' => 1
			), 
			'ap_purchasetype' => array (
					'title' => 'Type', 
					'required' => 0,
					'default'=>'service' 
			), 
			'ap_itemname' => array (
					'title' => 'Item Name', 
					'required' => 0 
			), 
			'ap_amount' => array (
					'title' => 'Amount', 
					'required' => 1 
			),
			'ap_quantity' => array (
					'title' => 'Quatity', 
					'required' => 0, 
					'default' => '1' 
			), 
			'ap_currency' => array (
					'title' => 'Currency', 
					'required' => 0,
					'default'=>'USD'
			), 
			'ap_periodlength' => array (
					'title' => 'Period Length', 
					'required' => 0
			), 
			'ap_timeunit' => array (
					'title' => 'Time Unit', 
					'required' => 0 
			), 
			'ap_periodcount' => array (
					'title' => 'Period Count', 
					'required' => 0 
			), 
			'ap_returnurl' => array (
					'title' => 'Return URL', 
					'required' => 0 
			),
			'ap_cancelurl' => array (
					'title' => 'Cancel URL', 
					'required' => 0 
			) ,
			'ap_description' => array (
					'title' => 'Description', 
					'required' => 0 
			) 
	);
	
	protected function _generateTransactionHash()
	{
		return md5($this->_info['ap_itemname'] . $this->_info['ap_amount'] . $this->_info['ap_description'] . rand(1, time()));
	}
	
	protected function _getDebugFormURL()
	{
		return 'https://sandbox.alertpay.com/sandbox/payprocess.aspx';
	}
	
	protected function _getLiveFormURL()
	{
		return 'https://www.alertpay.com/PayProcess.aspx';
	}
	
	protected function _getIPNURL()
	{
		if ($this->getDebugMode()) 
		{
			return 'https://sandbox.alertpay.com/sandbox/IPN2.ashx';
		}
		
		return 'https://www.alertpay.com/ipn2.ashx';
	}
	
	protected function _getFormMethod()
	{
		return 'POST';
	}
	
	protected function _getFormHiddenFields()
	{
		$this->_info['ap_itemcode']=$this->_additionalInfo['transactionhash'];
		
		return XenCentral_Framework_Helper_Html::constructHiddenCode($this->_info);
	}
	
	public function getMethodIdentifier($formatted=false)
	{
		if($formatted)
		{
			return 'AlertPay';
		}
		
		return 'alertpay';
	}
	
	protected function _getTransactionHashFromRequest()
	{
		return $this->_validatePaymentHash($this->getApi()->getRequest()->getParam('ap_itemcode'));
	}
	
	protected function _validateRequest()
	{
		$this->_setError('authentication_error', "Could not authenticate the request.");
		return false;
	}
	
	public function sendSuccessResponse()
	{
	
	}
	
	protected function _setTransactionIdFromRequest()
	{
		if($this->getDebugMode() && !$this->getApi()->getRequest()->getParam('ap_referencenumber'))
		{
			$this->getApi()->getRequest()->setParam('ap_referencenumber', uniqid('ap_'));
		}
		
		$this->setTransactionId($this->getApi()->getRequest()->getParam('ap_referencenumber'));
	}
	
	protected function _setTypeFromRequest()
	{
		if($this->getApi()->getRequest()->getParam('ap_status') == 'Success')
		{
			$this->setType('payment');
		}
		else if(false)
		{
			$this->setType('refund');
		}
		else
		{
			$this->setType('Unknow transaction type');
		}
	}

    /**
     * Merchant E-mail Address
     * @Required
     * @isField
     */
    function setSettingApMerchant($value)
    {
        $this->setSetting('ap_merchant', $value);
    }

    /**
     * Security Code
     * @Required
     */
    function setSettingApSecuritycode($value)
    {
        $this->setSetting('ap_securitycode', $value);
    }

    /**
     * IPN URL
     * @Required
     */
    function setFieldApAlerturl($value)
    {
        $this->setField('ap_alerturl', $value);
    }

    /**
     * Type
     * @default service
     */
    function setFieldApPurchasetype($value)
    {
        $this->setField('ap_purchasetype', $value);
    }

    /**
     * Item Name
     */
    function setFieldApItemname($value)
    {
        $this->setField('ap_itemname', $value);
    }

    /**
     * Amount
     * @Required
     */
    function setFieldApAmount($value)
    {
        $this->setField('ap_amount', $value);
    }

    /**
     * Quatity
     * @default 1
     */
    function setFieldApQuantity($value)
    {
        $this->setField('ap_quantity', $value);
    }

    /**
     * Currency
     * @default USD
     */
    function setFieldApCurrency($value)
    {
        $this->setField('ap_currency', $value);
    }

    /**
     * Period Length
     */
    function setFieldApPeriodlength($value)
    {
        $this->setField('ap_periodlength', $value);
    }

    /**
     * Time Unit
     */
    function setFieldApTimeunit($value)
    {
        $this->setField('ap_timeunit', $value);
    }

    /**
     * Period Count
     */
    function setFieldApPeriodcount($value)
    {
        $this->setField('ap_periodcount', $value);
    }

    /**
     * Return URL
     */
    function setFieldApReturnurl($value)
    {
        $this->setField('ap_returnurl', $value);
    }

    /**
     * Cancel URL
     */
    function setFieldApCancelurl($value)
    {
        $this->setField('ap_cancelurl', $value);
    }

    /**
     * Description
     */
    function setFieldApDescription($value)
    {
        $this->setField('ap_description', $value);
    }
}