<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/


class XenCentral_PaymentApi_Methods_2co extends XenCentral_PaymentApi_Method
{
	protected $_validSettings=array (
			'sid' => array (
					'title' => 'Vendor ID', 
					'required' => 1, 
					'field' => 1 
			), 
			'c_prod' => array (
					'title' => 'Product ID', 
					'required' => 1 
			), 
			'secret' => array (
					'title' => 'Secret Word', 
					'required' => 1, 
					'field' => 0 
			) 
	);
	
	protected $_validFields=array (
			'total' => array (
					'title' => 'Total', 
					'required' => 1 
			), 
			'tco_currency' => array (
					'title' => 'Currentcy', 
					'required' => 0, 
					'default' => 'USD' 
			), 
			'id_type' => array (
					'title' => 'Product Type', 
					'required' => 0, 
					'default' => 2 
			), 
			'x_Receipt_Link_URL' => array (
					'title' => 'IPN URL', 
					'required' => 0 
			), 
			'demo' => array (
					'title' => 'Demo Mode', 
					'required' => 0 
			) 
	);
	protected function _generateTransactionHash()
	{
		return md5($this->_settings['sid'] . $this->_info['cart_order_id'] . $this->_info['total'] . rand(1, time()));
	}
	
	protected function _validateSettings()
	{
		if(!$this->_settings['sid'])
		{
			$this->_setError('vendor_id', "Please fill 2CO vendor ID.");
			return false;
		}
		
		if(!$this->_settings['c_prod'])
		{
			$this->_setError('c_prod', "Please fill 2CO product ID.");
			return false;
		}
		
		return parent::_validateSettings();
	}
	
	protected function _validateInfo()
	{
		if(!$this->_info['total'])
		{
			$this->_setError('total_amount', "Please specify the amount to be paid");
			return false;
		}
		
		return parent::_validateInfo();
	}
	
	protected function _getDebugFormURL()
	{
		// the same as live URL
		return $this->_getLiveFormURL();
	}
	
	protected function _getLiveFormURL()
	{
		return 'https://www.2checkout.com/checkout/purchase';
	}
	
	protected function _getFormMethod()
	{
		return 'POST';
	}
	
	protected function _getFormHiddenFields()
	{
		$this->_info['custom']=$this->_info['cart_order_id']=$this->_additionalInfo['transactionhash'];
		
		if($this->getDebugMode())
		{
			$this->setField('demo', 'Y');
		}
		
		return XenCentral_Framework_Helper_Html::constructHiddenCode($this->_info);
	}
	
	public function getMethodIdentifier($formatted=false)
	{
		if($formatted)
		{
			return '2CheckOut';
		}
		
		return '2co';
	}

    protected function _getTransactionHashFromRequest()
    {
        if ($this->_validatePaymentHash($this->getApi()->getRequest()->getParam('item_id_1'))) {
            return $this->_validatePaymentHash($this->getApi()->getRequest()->getParam('item_id_1'));
        } else {
            return $this->_validatePaymentHash($this->getApi()->getRequest()->getParam('custom'));
        }
    }

    protected function sendFailResponse()
    {
        $errors = reset($this->_errors);
        print_r($errors);
    }

    protected function _validateRequest()
    {
        // validate some variables between IPN versions
        if (!$this->getApi()->getRequest()->getParam('md5_hash')) {
            // this is used as return script
            if (strtoupper($this->getApi()->getRequest()->getParam('key')) !== strtoupper(md5($this->getSettings('secret') . $this->getSettings('sid') . $this->getApi()->getRequest()->getParam('order_number') . $this->getApi()->getRequest()->getParam('total')))) {
                $this->_setError('authentication_error',
                        "Could not authenticate the request. " . $this->getApi()->getRequest()->getParam('key') . '-' . 'secret' . ' - ' . $this->getSettings('sid') . '-' . $this->getApi()->getRequest()->getParam('order_number') . '-'
                                . $this->getApi()->getRequest()->getParam('total')
                );
                return false;
            }
        } else {
            if (strtoupper($this->getApi()->getRequest()->getParam('md5_hash')) !== strtoupper(md5($this->getApi()->getRequest()->getParam('sale_id') . $this->getSettings('sid') . $this->getApi()->getRequest()->getParam('invoice_id') . $this->getSettings('secret')))) {
                $this->_setError('authentication_error',
                        "Could not authenticate the request. " . $this->getApi()->getRequest()->getParam('md5_hash') . '-' . $this->getApi()->getRequest()->getParam('sale_id') . '-' . $this->getSettings('sid') . '-'
                                . $this->getApi()->getRequest()->getParam('invoice_id')
                                . '-' . 'secret');
                return false;
            }
        }


        return true;
    }
	
	public function sendSuccessResponse()
	{
	
	}
	
	protected function _setTransactionIdFromRequest()
	{
        return $this->setTransactionId(isset($this->getApi()->getRequest()->getParam('sale_id')) ? $this->getApi()->getRequest()->getParam('sale_id') : $this->getApi()->getRequest()->getParam('order_number'));
	}
	
	protected function _setTypeFromRequest()
	{
		if(empty($this->getApi()->getRequest()->getParam('message_type')) OR $this->getApi()->getRequest()->getParam('message_type') == 'ORDER_CREATED')
		{
			$this->setType('payment');
		}
		else if(in_array($this->getApi()->getRequest()->getParam('message_type'), array (
				'REFUND_ISSUED', 
				'RECURRING_INSTALLMENT_FAILED', 
				'RECURRING_STOPPED' 
		)))
		{
			$this->setType('refund');
		}
		else
		{
			$this->setType('Unknow transaction type');
		}
	}

    /**
     * Vendor ID
     * @Required
     * @isField
     */
    function setSettingSid($value)
    {
        $this->setSetting('sid', $value);
    }

    /**
     * Product ID
     * @Required
     */
    function setSettingCProd($value)
    {
        $this->setSetting('c_prod', $value);
    }

    /**
     * Secret Word
     * @Required
     */
    function setSettingSecret($value)
    {
        $this->setSetting('secret', $value);
    }

    /**
     * Total
     * @Required
     */
    function setFieldTotal($value)
    {
        $this->setField('total', $value);
    }

    /**
     * Currentcy
     * @default USD
     */
    function setFieldTcoCurrency($value)
    {
        $this->setField('tco_currency', $value);
    }

    /**
     * Product Type
     * @default 2
     */
    function setFieldIdType($value)
    {
        $this->setField('id_type', $value);
    }

    /**
     * IPN URL
     */
    function setFieldXReceiptLinkURL($value)
    {
        $this->setField('x_Receipt_Link_URL', $value);
    }

    /**
     * Demo Mode
     */
    function setFieldDemo($value)
    {
        $this->setField('demo', $value);
    }

}