<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/

class XenCentral_PaymentApi_MethodList
{
    protected $controller_prefix;

    protected $handler_name;

    protected $title;

    protected $item_id;

    protected $price;

    protected $currency;

    /**
     * @var XenCentral_PaymentApi_Method[]
     */
    protected $methods=array();

    protected $additional_information;

    public function __construct(
        $controller_prefix,
        $handler_name,
        $title,
        $item_id,
        $price,
        $currency
    )
    {
        $handlerClass = new ReflectionClass($handler_name);
        if (!$handlerClass->implementsInterface('XenCentral_Framework_ControllerPublic_PaymentApiInterface')) {
            throw new XenForo_Exception("$handler_name is not valid payment API handler. It should implement XenCentral_Framework_ControllerPublic_PaymentApiInterface");
        }

        $this->controller_prefix=$controller_prefix;
        $this->handler_name=$handler_name;
        $this->title=$title;
        $this->item_id=$item_id;
        $this->price=$price;
        $this->currency=$currency;
    }

    public function getForms(&$errors)
    {
        $forms=array();
        foreach($this->methods AS $method) {
            if($form=$method->getFormComponents()) {
                $forms[$method->getMethodIdentifier()]=$form;
            } else {
                $errors=array_merge($errors, $method->getErrors());
            }
        }

        return $forms;
    }

    public function addManualMethod($debugMode, $instructions='')
    {
        if(!$instructions) {
            $instructions=XenForo_Application::getOptions()->get('xcfw_manual_payment_instructions');
        }

        if(!$instructions) {
            return;
        }

        $returnUrl = $this->_getIpnUrl('Manual', 'return');
        $notifyUrl = $this->_getIpnUrl('Manual', 'notify');

        /** @var XenCentral_PaymentApi_Methods_Manual $manual */
        $manual = $this->_getPaymentApi()->getMethod('Manual');
        $manual->setDebugMode(false);
        $manual->setSettingEndpointUrl($notifyUrl);
        $manual->setSettingInstructionsUrl($this->_getIpnUrl('Manual', 'payment-instructions'));
        $manual->setSettingInstructions($instructions);

        $manual->setAdditionalInfo($this->additional_information);

        $manual->setFieldCurrencyCode($this->currency);
        $manual->setFieldAmount($this->price);
        $manual->setFieldItemName($this->title);
        $manual->setFieldItemNumber($this->item_id);

        $manual->setFieldReturn($returnUrl);

        $this->methods[] = $manual;
    }

    public function addPayPal($paypalEmail, $debugMode)
    {
        $returnUrl = $this->_getIpnUrl('Paypal', 'return');
        $notifyUrl = $this->_getIpnUrl('Paypal', 'notify');
        $cancelUrl = $this->_getIpnUrl('Paypal', 'cancel');

        /** @var XenCentral_PaymentApi_Methods_Paypal $paypal */
        $paypal = $this->_getPaymentApi()->getMethod('Paypal');
        $paypal->setDebugMode($debugMode);
        $paypal->setSetting('business', $paypalEmail);

        $paypal->setAdditionalInfo($this->additional_information);

        $paypal->setFieldCurrencyCode($this->currency);
        $paypal->setFieldAmount($this->price);
        $paypal->setFieldItemName($this->title);
        $paypal->setFieldItemNumber($this->item_id);

        $paypal->setFieldReturn($returnUrl);
        $paypal->setFieldNotifyUrl($notifyUrl);
        $paypal->setFieldCancelReturn($cancelUrl);

        $this->methods[]=$paypal;
    }

    public function addLocalMethod()
    {
        $returnUrl = $this->_getIpnUrl('Local', 'return');
        $notifyUrl = $this->_getIpnUrl('Local', 'notify');

        /** @var XenCentral_PaymentApi_Methods_Local $local */
        $local = $this->_getPaymentApi()->getMethod('Local');
        $local->setDebugMode(true);
        $local->setSettingEndpointUrl($notifyUrl);

        $local->setAdditionalInfo($this->additional_information);

        $local->setFieldCurrencyCode($this->currency);
        $local->setFieldAmount($this->price);
        $local->setFieldItemName($this->title);
        $local->setFieldItemNumber($this->item_id);

        $local->setFieldReturn($returnUrl);

        $this->methods[]=$local;
    }

    /**
     * @param mixed $additional_information
     */
    public function setAdditionalInformation($additional_information)
    {
        $this->additional_information = $additional_information;
    }

    protected function _getIpnUrl($methodName, $action)
    {
        return XenForo_Link::buildPublicLink('full:' . $this->controller_prefix . '/purchase-'.$action, null, array('PaymentMethod' => $methodName));
    }

    protected function _getPaymentApi()
    {
        return XenCentral_PaymentApi_Module::getInstance();
    }
}