<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/
 
/**
 * Used for item manager pages 
 * @package XenCentral_Framework
 *
 */
abstract class XenCentral_Framework_Tools_ManagerInfo
{
	/**
	 * Holds all information in keyed array
	 * @var array
	 */
	protected $_info;
	
	public function setInfo($info)
	{
		$this->_info=$info;
	}
	
	public function getInfo($key)
	{
		return $this->_info[$key];
	}
	
	public function getItemTitle()
	{
		return $this->getInfo('itemTitle');
	}
	
	public function getTemplatePrefix()
	{
		return $this->getInfo('templatePrefix');
	}
	
	public function getDataWriterName()
	{
		return $this->getInfo('dataWriterName');
	}
	
	public function getIndexLink()
	{
		return $this->getInfo('indexLink');
	}
	
	public function getItemTable()
	{
		return $this->getInfo('itemTable');
	}
	
	public function getPrimaryKeyName()
	{
		return $this->getInfo('primaryKeyName');
	}
	
	public function getPhrasePrefix()
	{
		return $this->getInfo('phrasePrefix');
	}
	
	public function getPhrasePrefixGeneral()
	{
		return $this->getInfo('phrasePrefixGeneral');
	}
	
	public function getManagerViewName()
	{
		return $this->getInfo('managerViewName');
	}
	
	public function getNotFoundErrorPhrase()
	{
		return $this->getInfo('notFoundPhrase');
	}
	
	public function getModelClassName()
	{
		return $this->getInfo('modelClassName');
	}
	
	public function getFields($table=false)
	{
		$fields=$this->getInfo('dbFieldInfo');
		
		if ($table)
		{
			return $fields[$this->getItemTable()];
		}
		
		return $fields;
	}
	
	public function getDefaultPhrases()
	{
		$phrases=array();
		
		$fields=$this->getFields();
		
		$fields=$fields[$this->getItemTable()];
		
		foreach ($fields AS $title=>$fieldInfo)
		{
			$phrases[$title]=$this->getFieldPhrase($title);
			$phrases[$title.'_desc']=$this->getFieldPhrase($title, '_desc');
		}
		
		// prepare general manager phrases
		$generalManagerPhrases=array(
			'add',
			'edit'
		);
		
		foreach ($generalManagerPhrases AS $title)
		{
			$phrases[$title]=$this->getFieldPhrase($title);
		}
		
		// prepare phrases that can be used in all managers
		$generalPhrases=array(
			'delete',
			'save'
		);
		
		foreach ($generalPhrases AS $title)
		{
			$phrases[$title]=$this->getGeneralPhrase($title);
		}
		
		return $phrases;
	}
	
	protected function getFieldPhrase($mainPhrase, $postfix='')
	{
		$phrase=$this->getPhrasePrefix().'_'.$mainPhrase;
		
		if ($postfix)
		{
			$phrase=$phrase.$postfix;
		}
		
		return $phrase;
	}
	
	protected function getGeneralPhrase($mainPhrase)
	{
		return $this->getPhrasePrefixGeneral().'_'.$mainPhrase;
	}
}