<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/

class XenCentral_Framework_Route_PrefixPublic_Main implements XenForo_Route_Interface
{
    /**
     * Match a specific route for an already matched prefix.
     *
     * @see XenForo_Route_Interface::match()
     */
    public function match($routePath, Zend_Controller_Request_Http $request, XenForo_Router $router)
    {
        $routeArray = explode('/', $routePath);

        $basePath = array_shift($routeArray);

        switch ($basePath) {
            case 'paymentapi':
                return $router->getRouteMatch('XenCentral_Framework_ControllerPublic_PaymentApi', implode('/', $routeArray), 'xcfw');
            default:
                array_unshift($routeArray, $basePath);
                return $router->getRouteMatch('XenCentral_Framework_ControllerPublic_Index', implode('/', $routeArray), 'xcfw');
        }
    }

    /**
     * Method to build a link to the specified page/action with the provided
     * data and params.
     *
     * @see XenForo_Route_BuilderInterface
     */
    public function buildLink($originalPrefix, $outputPrefix, $action, $extension, $data, array &$extraParams)
    {
        if (strpos($action, '/') === false) {
            return XenForo_Link::buildBasicLink($outputPrefix, $action, $extension);
        }

        $routeArray = explode('/', $action);

        $basePath = array_shift($routeArray);

        switch ($basePath) {
            default:
                return XenForo_Link::buildBasicLink($outputPrefix, $action, $extension);
                break;
        }
    }
}