<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/

class XenCentral_Framework_Route_PrefixAdmin_Framework implements XenForo_Route_Interface
{
	/**
	 * Match a specific route for an already matched prefix.
	 *
	 * @see XenForo_Route_Interface::match()
	 */
	public function match($routePath, Zend_Controller_Request_Http $request, XenForo_Router $router)
	{
        $routePath=explode('/', $routePath);
        switch($routePath[0])
        {
            case 'paymentapi':
                array_shift($routePath);
                return $router->getRouteMatch('XenCentral_Framework_ControllerAdmin_PaymentApi', implode('/', $routePath), 'xcfw');
                break;
            default:
                return $router->getRouteMatch('XenCentral_Framework_ControllerAdmin_Framework', implode('/', $routePath), 'xcfw');
                break;
        }
	}
}
