<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/


/**
 * Route prefix handler for categories in the public system.
 *
 * @package XenForo_Attachment
 */
class XenCentral_Framework_Route_PrefixAdmin_Attachments implements XenForo_Route_Interface
{
	/**
	 * Match a specific route for an already matched prefix.
	 *
	 * @see XenForo_Route_Interface::match()
	 */
	public function match($routePath, Zend_Controller_Request_Http $request, XenForo_Router $router)
	{
		$action = $router->resolveActionWithIntegerParam($routePath, $request, 'attachment_id');
		return $router->getRouteMatch('XenCentral_Framework_ControllerAdmin_Attachment', $action);
	}

	/**
	 * Method to build a link to the specified page/action with the provided
	 * data and params.
	 *
	 * @see XenForo_Route_BuilderInterface
	 */
	public function buildLink($originalPrefix, $outputPrefix, $action, $extension, $data, array &$extraParams)
	{
		if (!empty($data['temp_hash']) && empty($data['content_id']))
		{
			$extraParams['temp_hash'] = $data['temp_hash'];
		}

		if ($data && isset($data['attachment_filename']) && !isset($data['filename']))
		{
			$data['filename'] = $data['attachment_filename'];
		}

		return XenForo_Link::buildBasicLinkWithIntegerParam($outputPrefix, $action, $extension, $data, 'attachment_id', 'filename');
	}
}