<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/

class XenCentral_Framework_Option_Default
{
	public static function renderUsergroups(XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
	{
		$preparedOption['formatParams']=XenForo_Model::create('XenCentral_Framework_Model_GetUserGroups')->getUserGroupOptions($preparedOption['option_value']);
		
		return XenForo_ViewAdmin_Helper_Option::renderOptionTemplateInternal('option_list_option_checkbox', $view, $fieldPrefix, $preparedOption, $canEdit);
	}

    public static function renderNodesSelector(XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
    {
        $nodes = XenForo_Model::create('XenForo_Model_Node')->getAllNodes();

        $html = $view->createTemplateObject('xcfw_option_list_select_forum', array(
            'selNodeIds' => $preparedOption['option_value'],
            'nodes' => $nodes,
            'fieldPrefix' => $fieldPrefix,
            'preparedOption' => $preparedOption
        ));

        $preparedOption['formatParams'] = $html;

        return XenForo_ViewAdmin_Helper_Option::renderOptionTemplateInternal('xcfw_option_list_html',
            $view, $fieldPrefix, $preparedOption, $canEdit
        );
    }
}
