<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/

class XenCentral_Framework_Model_PaymentApi extends XenForo_Model
{
    public function countPayments()
    {
        return $this->_getDb()->fetchOne('
            SELECT COUNT(*) FROM xcfw_paymentapi_manual_transaction
        ');
    }

    public function getPayments($conditions, $fetchOptions)
    {
        $whereClause = $this->preparePaymentConditions($conditions, $fetchOptions);

        $orderClause = $this->preparePaymentOrderOptions($fetchOptions, 'payment.dateline');
        $joinOptions = $this->preparePaymentFetchOptions($fetchOptions);
        $limitOptions = $this->prepareLimitFetchOptions($fetchOptions);

        return $this->fetchAllKeyed($this->limitQueryResults(
                '
                    SELECT payment.*
                        ' . $joinOptions['selectFields'] . '
				FROM xcfw_paymentapi_manual_transaction AS payment
				' . $joinOptions['joinTables'] . '
				WHERE ' . $whereClause . '
				' . $orderClause . '
			', $limitOptions['limit'], $limitOptions['offset']
        ), 'txn_id');
    }

    public function getNewManualTransactionId()
    {
        $txn_id = '';

        while (true) {
            $txn_id='';
            for($i=0;$i<10;$i++) {
                $txn_id .= substr(str_shuffle("123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 1);
            }

            if ($this->_getDb()->fetchRow('
                SELECT * FROM xcfw_paymentapi_manual_transaction
                WHERE txn_id=?
            ', array($txn_id)) == false
            ) {
                break;
            }
        }

        return $txn_id;
    }
    public function createManualPayment($txn_id, $transaction_hash, $handler)
    {
        if($this->_getDb()->fetchRow('
                SELECT * FROM xcfw_paymentapi_manual_transaction
                WHERE txn_id=?
            ', array($txn_id))) {
            return $txn_id;
        }

        $this->_getDb()->insert('xcfw_paymentapi_manual_transaction', array(
            'txn_id'=>$txn_id,
            'transaction_hash'=> $transaction_hash,
            'user_id'=>XenForo_Visitor::getInstance()->getUserId(),
            'purchase_handler'=> $handler,
            'dateline'=>time(),
            'request'=>serialize($_POST)
        ));

        return $txn_id;
    }

    /**
     * Prepares join-related fetch options.
     *
     * @param array $fetchOptions
     *
     * @return array Containing 'selectFields' and 'joinTables' keys.
     */
    public function preparePaymentFetchOptions(array $fetchOptions)
    {
        $selectFields = '';
        $joinTables = '';

        $selectFields.=', user.username, transaction.status';

        $joinTables.='
            LEFT JOIN xf_user AS user ON user.user_id=payment.user_id
            LEFT JOIN xcfw_paymentapi_transaction AS transaction_info ON transaction_info.transactionhash=payment.transaction_hash
            LEFT JOIN xcfw_paymentapi_transactionlog AS transaction ON transaction.infoid=transaction_info.id
        ';

        return array(
                'selectFields' => $selectFields,
                'joinTables' => $joinTables
        );
    }

    /**
     * Prepares a set of conditions to select payments against.
     *
     * @param array $conditions List of conditions. (TODO: make list)
     * @param array $fetchOptions The fetch options that have been provided. May be edited if criteria requires.
     *
     * @return string Criteria as SQL for where clause
     */
    public function preparePaymentConditions(array $conditions, array &$fetchOptions)
    {
        $db = $this->_getDb();
        $sqlConditions = array();

        if (!empty($conditions['txn_id'])) {
            $sqlConditions[] = 'payment.txn_id = ' . $db->quote($conditions['txn_id']);
        }

        if(!empty($conditions['id_match'])) {
            $sqlConditions[]='payment.txn_id LIKE '. XenForo_Db::quoteLike($conditions['id_match'], 'lr');
        }

        return $this->getConditionsForClause($sqlConditions);
    }

    /**
     * Construct 'ORDER BY' clause
     *
     * @param array $fetchOptions (uses 'order' key)
     * @param string $defaultOrderSql Default order SQL
     *
     * @return string
     */
    public function preparePaymentOrderOptions(array &$fetchOptions, $defaultOrderSql = '')
    {
        $choices = array(
                'dateline' => 'payment.dateline',
        );

        return $this->getOrderByClause($choices, $fetchOptions, $defaultOrderSql);
    }
}