<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/


class XenCentral_Framework_Model_Notification extends XenForo_Model
{
    /**
     * Used to send conversation messages
     * @param $emailTemplateId - should have plain text specified or the text version of HTML
     * @param array $from - the user who should send the conversation
     * @param array $toUsers - array of users to get the conversation, each value full user array
     * @param array $params - any additional parameters needed to render the template
     * @return bool
     * @throws Exception
     * @throws XenForo_Exception
     */
    public function sendPrivateMessage($emailTemplateId, array $from, array $toUsers, array $params = array())
    {
        foreach ($toUsers AS $user) {
            $mail = XenForo_Mail::create($emailTemplateId, $params, $user['language_id']);

            $contents = $mail->prepareMailContents();

            if (empty($contents['bodyText'])) {
                $message = XenForo_Html_Renderer_BbCode::renderFromHtml($contents['bodyHtml']);
            } else {
                $message = $contents['bodyText'];
            }

            /** @var XenForo_DataWriter_ConversationMaster $conversationDw */
            $conversationDw = XenForo_DataWriter::create('XenForo_DataWriter_ConversationMaster');
            $conversationDw->setExtraData(XenForo_DataWriter_ConversationMaster::DATA_ACTION_USER, $from);
            $conversationDw->set('user_id', $from['user_id']);
            $conversationDw->set('username', $from['username']);
            $conversationDw->set('title', $contents['subject']);
            $conversationDw->set('open_invite', 1);
            $conversationDw->set('conversation_open', 1);
            $conversationDw->addRecipientUserNames(array($user['username']));

            $messageDw = $conversationDw->getFirstMessageDw();
            $messageDw->set('message', $message);

            $conversationDw->preSave();

            try {
                $conversationDw->save();
            } catch (Exception $ex) {
                $exception = new XenForo_Exception("
                Unable to send PM to user: {$user['username']} from user: {$from['username']} message: " . $ex->getMessage() . ", Trace "
                        . $ex->getTraceAsString() . "
            ", false);
                XenForo_Error::logException($exception, false);
            }

            $conversation = $conversationDw->getMergedData();

            $this->_getConversationModel()->markConversationAsRead(
                    $conversation['conversation_id'], $from['user_id'], XenForo_Application::$time
            );
        }


        return true;
    }

    public function sendRedirectAlert($user_id,  $message, $link, $sender_id, $sender_name, $message_params=array(), $link_type='', $link_params=array())
    {
        // save the entry to the database
        $redirect=new XenCentral_Framework_Items_Redirect();
        $redirect->setUserId($user_id);
        $redirect->setMessage($message);
        $redirect->setLink($link);
        $redirect->setMessageParams($message_params);
        $redirect->setLinkType($link_type);
        $redirect->setLinkParams($link_params);

        if($redirect->save()) {
            $redirectId=$redirect->getRedirectId();

            XenForo_Model_Alert::alert($user_id, $sender_id, $sender_name, 'redirect_helper', $redirectId, 'private');

            return true;
        }

        return false;
    }

    /**
     * @return XenForo_Model_Conversation
     */
    protected
    function _getConversationModel()
    {
        return $this->getModelFromCache('XenForo_Model_Conversation');
    }
}