<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/


/**
 * Model for manager items.
 *
 * @package XenCentral
 */
class XenCentral_Framework_Model_Manager extends XenForo_Model
{
	/**
	 * @var XenCentral_Framework_Tools_ManagerInfo
	 */
	protected $_managerInfo;
	
	public function setManagerInfo($_managerInfo)
	{
		if ($this->_managerInfo===null)
		{
			$this->_managerInfo=$_managerInfo;
		}
	}
	
	public function getManagerInfo()
	{
		return $this->_managerInfo;
	}
	
	/**
	 * Gets the named items.
	 *
	 * @param integer $id
	 *
	 * @return array|false
	 */
	public function getItemById($id)
	{
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM '.$this->getManagerInfo()->getItemTable().'
			WHERE '.$this->getManagerInfo()->getPrimaryKeyName().' = ?
		', $id);
	}

	/**
	 * Gets all items, ordered by their displayorder (ascending).
	 *
	 * @return array Format: [item id] => info
	 */
	public function getAllItems()
	{
		return $this->fetchAllKeyed('
			SELECT *
			FROM '.$this->getManagerInfo()->getItemTable().'
			ORDER BY displayorder ASC
		', $this->getManagerInfo()->getPrimaryKeyName());
	}

	/**
	 * Prepares an item for display.
	 *
	 * @param array $item
	 *
	 * @return array
	 */
	public function prepareItem(array $item)
	{
		return $item;
	}

	/**
	 * Prepares a list of items for display.
	 *
	 * @param array $items
	 *
	 * @return array
	 */
	public function prepareItems(array $items)
	{
		foreach ($items AS &$item)
		{
			$item = $this->prepareItem($item);
		}

		return $items;
	}

	/**
	 * Gets information about the default item for use when adding
	 * a new item. Includes prepared data.
	 *
	 * @return array
	 */
	public function getDefaultItem()
	{
		return array(
			 $this->getManagerInfo()->getPrimaryKeyName() => 0,
			 'active'=>1,
			 'displayorder'=>10
		);
	}

	/**
	 * @return XenForo_Model_Phrase
	 */
	protected function _getPhraseModel()
	{
		return $this->getModelFromCache('XenForo_Model_Phrase');
	}

	/**
	 * @return XenForo_Model_Alert
	 */
	protected function _getAlertModel()
	{
		return $this->getModelFromCache('XenForo_Model_Alert');
	}	
}