<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/


class XenCentral_Framework_Model_GetUserGroups extends XenForo_Model
{
	
	// returns a list user groups with the exception of Administrative, Moderating, and Unregistered
	public function getUserGroupOptions($selectedGroupIds)
	{
		
		$userGroups=array ();
		foreach($this->getAppropriateUserGroups() as $userGroup)
		{
			$userGroups[]=array (
					'label' => $userGroup['title'], 
					'value' => $userGroup['user_group_id'], 
					'selected' => in_array($userGroup['user_group_id'], $selectedGroupIds) 
			);
		}
		
		return $userGroups;
	
	}
	
	public function getAppropriateUserGroups()
	{
		
		return $this->_getDb()->fetchAll('
            SELECT user_group_id, title
            FROM xf_user_group
            ORDER BY user_group_id
            ');
	
	}

}

