<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/

class XenCentral_Framework_Model_GeoCoding extends XenForo_Model
{
    protected static $handler;
    public function getCountryArray()
    {
        if (!class_exists('GeoIP', false)) {
            require_once dirname(__FILE__) . '/../vendor/geoip-api/geoip.class.php';
        }

        $geoIp=new GeoIP();

        $countryNames=$geoIp->GEOIP_COUNTRY_NAMES;
        $countryCodes= $geoIp->GEOIP_COUNTRY_CODES;

        return array_combine($countryCodes, $countryNames);
    }

    public function getCountry($ip)
    {
        static $cache;

        if (isset($cache[$ip])) {
            return $cache[$ip];
        }

        $cache[$ip] = 'n_a';

        $array = $this->getCountryCityArray($ip);
        if ($array) {
            $cache[$ip] = $array['country_name'];
        }

        return $cache[$ip];
    }

    public function getCountryCode($ip)
    {
        static $cache;

        if(isset($cache[$ip])) {
            return $cache[$ip];
        }

        $cache[$ip]='n_a';

        $array = $this->getCountryCityArray($ip);
        if ($array) {
            $cache[$ip]= $array['country_code'];
        }

        return $cache[$ip];
    }

    public function getCountryCityArray($ip)
    {
        static $GEOIP_REGION_NAME;

        if(!function_exists('getrecordwithdnsservice')) {
            require_once dirname(__FILE__) . '/../vendor/geoip-api/geoipcity.inc';
        }

        if(is_null($GEOIP_REGION_NAME)) {
            include dirname(__FILE__) . '/../vendor/geoip-api/geoipregionvars.php';
        }

        $gi=$this->_getHandler();

        $record = geoip_record_by_addr($gi, $ip);
        if (!$record) {
            return false;
        }
        $return = array();
        foreach (array('country_code', 'country_name', 'region', 'city') AS $key) {
            if ($record->$key) {
                if (
                        $key == 'region'
                        AND !empty($GEOIP_REGION_NAME[$record->country_code][$record->region])
                ) {
                    $return [$key] = $record->region . ' - ' . $GEOIP_REGION_NAME[$record->country_code][$record->region];
                } else {
                    $return[$key] = $record->$key;
                }
            }
        }

        return $return;
    }

    protected function _getHandler()
    {
        if(is_null(self::$handler)) {
            if (!function_exists('geoip_open')) {
                require_once dirname(__FILE__) . '/../vendor/geoip-api/geoip.inc';
            }

            self::$handler = geoip_open(dirname(__FILE__) . '/../Resources/GeoLiteCity.dat', GEOIP_STANDARD);
        }

        return self::$handler;
    }

    function __destruct()
    {
        if(function_exists('geoip_close') AND !empty(self::$handler)) {
            geoip_close(self::$handler);
        }
    }


}