<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/

/**
 * Proxy class for XenForo Cache if it is setup or custom file cache otherwise
 */
class XenCentral_Framework_Model_Cache extends XenForo_Model
{
    protected $_cache;

    public function __construct()
    {
        $xenForoCache=XenForo_Application::getCache();
        if($xenForoCache===false) {
            $cacheDir= XenForo_Application::getInstance()->getRootDir() . '/internal_data/xcfw_cache';
            if(!is_dir($cacheDir)) {
                mkdir($cacheDir);
                chmod($cacheDir, 0777);
                file_put_contents($cacheDir.'/index.html', '');
            }
            $engine = 'File';
            // use file system
            $backendConfig = array(
                'cache_dir' => $cacheDir,
                'hashed_directory_level' => 1,
                'hashed_directory_perm' => 0755,
                'cache_directory_umask' => 0755,
                'cache_file_perm' => 0644,
                'cache_file_umask' => 0644
            );

            $xenForoCache = Zend_Cache::factory('Core', $engine, array(
                    'cache_id_prefix' => 'xcfw_',
                    'lifetime' => 3600,
                    'write_control' => true,
                    'automatic_cleaning_factor' => 0,
                    'automatic_serialization' => false
                ),
                $backendConfig
            );
        }

        $this->_cache=$xenForoCache;
    }

    public function load($id, $doNotTestCacheValidity = false, $doNotUnserialize = false)
    {
        static $arrayCache=array();

        if(!empty($arrayCache[$id]) AND $doNotTestCacheValidity==false) {
            return $arrayCache[$id];
        }

        $data=$this->_cache->load($id, $doNotTestCacheValidity, $doNotUnserialize);
        if(is_string($data)) {
            $unSerialized=@unserialize($data);
            if($unSerialized!==false) {
                $arrayCache[$id]= $unSerialized;
                return $unSerialized;
            }
        }

        $arrayCache[$id] = $data;
        return $data;
    }

    public function clean($mode = 'all', $tags = array())
    {
        return $this->_cache->clean($mode, $tags); 
    }

    public function remove($id)
    {
        return $this->_cache->remove($id); 
    }

    public function save($data, $id = null, $tags = array(), $specificLifetime = false, $priority = 8)
    {
        if($data===false) {
            return $this->remove($id);
        }

        if(!is_string($data)) {
            $data=serialize($data);
        }
        return $this->_cache->save($data, $id, $tags, $specificLifetime, $priority); 
    }

    public function test($id)
    {
        return $this->_cache->test($id); 
    }

    /**
     * @param $name
     * @param $arguments
     * @return mixed
     * Proxy all other calls
     */
    function __call($name, $arguments)
    {
        return call_user_func_array(array($this->_cache, $name), $arguments);
    }
}