<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/

/**
 * @var XenForo_Model_AddOn
 * @class XenCentral_Framework_Model_AddOn
 * @extends XenForo_Model_AddOn
 */
class XenCentral_Framework_Model_AddOn extends XFCP_XenCentral_Framework_Model_AddOn
{
    protected static $skipRebuilds=array();

    public function importAddOnExtraDataFromXml(SimpleXMLElement $xml, $addOnId)
    {
        if (!XenForo_Application::getOptions()->get('xcfw_skip_rebuild')) {
            return parent::importAddOnExtraDataFromXml($xml, $addOnId);
        }

        $adminTemplates = XenForo_Helper_DevelopmentXml::fixPhpBug50670($xml->admin_templates->template);
        $adminTemplateMods = XenForo_Helper_DevelopmentXml::fixPhpBug50670($xml->admin_template_modifications->modification);

        $emailTemplates= XenForo_Helper_DevelopmentXml::fixPhpBug50670($xml->email_templates->template);
        $emailTemplateMods= XenForo_Helper_DevelopmentXml::fixPhpBug50670($xml->email_template_modifications->modification);

        $templates = XenForo_Helper_DevelopmentXml::fixPhpBug50670($xml->templates->template);
        $templateMods = XenForo_Helper_DevelopmentXml::fixPhpBug50670($xml->public_template_modifications->modification);

        $phrases = XenForo_Helper_DevelopmentXml::fixPhpBug50670($xml->phrases->phrase);

        if (empty($adminTemplates) AND empty($adminTemplateMods)) {
            self::$skipRebuilds[] = 'AdminTemplate';
            self::$skipRebuilds[] = 'AdminTemplateReparse';
        }

        if (empty($templates) AND empty($templateMods)) {
            self::$skipRebuilds[] = 'Template';
            self::$skipRebuilds[] = 'TemplateReparse';
        }

        if (empty($emailTemplates) AND empty($emailTemplateMods)) {
            self::$skipRebuilds[] = 'EmailTemplate';
            self::$skipRebuilds[] = 'EmailTemplateReparse';
        }

        if(empty($phrases)) {
            self::$skipRebuilds[] = 'Phrase';
        }

        return parent::importAddOnExtraDataFromXml($xml, $addOnId);
    }

    public function rebuildAddOnCaches()
    {
        if(empty(self::$skipRebuilds)) {
            return parent::rebuildAddOnCaches();
        }

        $this->getModelFromCache('XenForo_Model_CodeEvent')->rebuildEventListenerCache();

        $this->getModelFromCache('XenForo_Model_Cron')->updateMinimumNextRunTime();

        $this->getModelFromCache('XenForo_Model_Option')->rebuildOptionCache();

        $this->getModelFromCache('XenForo_Model_RoutePrefix')->rebuildRoutePrefixCache();

        $this->getModelFromCache('XenForo_Model_StyleProperty')->rebuildPropertyCacheForAllStyles();

        $this->getModelFromCache('XenForo_Model_BbCode')->rebuildBbCodeCache();

        $this->getModelFromCache('XenForo_Model_ContentType')->rebuildContentTypeCache();

        $this->getModelFromCache('XenForo_Model_AdminSearch')->rebuildSearchTypesCache();

        $this->getModelFromCache('XenForo_Model_BbCode')->updateBbCodeParseCacheVersion();

        $rebuild=array_diff(array('Permission', 'Phrase', 'TemplateReparse', 'Template', 'AdminTemplateReparse', 'AdminTemplate', 'EmailTemplateReparse', 'EmailTemplate'), self::$skipRebuilds);

        XenForo_Application::defer('Atomic',
                array('simple' => $rebuild),
                'addonRebuild', true
        );
    }

    /**
     * @return XenCentral_Framework_Model_BrowserLog
     */
    protected function _getLogModel()
    {
        return $this->getModelFromCache('XenCentral_Framework_Model_BrowserLog');
    }
}