<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/


class XenCentral_Framework_Items_Redirect
{
    protected $redirect_id;

    protected $user_id;

    protected $message;

    protected $message_params = array();

    protected $link;

    protected $link_type = '';

    protected $link_params = array();

    public function getFinalUrl()
    {
        if ($this->getLinkParams()) {
            if ($this->getLinkType() == 'admin') {
                return XenForo_Link::buildAdminLink(
                        $this->getLink(),
                        null,
                        $this->getLinkParams()
                );
            }
            return XenForo_Link::buildPublicLink(
                    $this->getLink(),
                    null,
                    $this->getLinkParams()
            );
        }

        return $this->getLink();
    }

    public function getFinalMessage()
    {
        if ($this->getMessageParams()) {
            return new XenForo_Phrase(
                    $this->getMessage(),
                    $this->getMessageParams()
            );
        }

        return $this->getMessage();
    }

    public function save()
    {
        $data = array(
                'user_id' => $this->getUserId(),
                'message' => $this->getMessage(),
                'message_params' => serialize($this->getMessageParams()),
                'link' => $this->getLink(),
                'link_type' => $this->getLinkType(),
                'link_params' => serialize($this->getLinkParams())
        );
        if ($this->redirect_id) {
            XenForo_Application::getDb()->update('xcfw_redirect_alert', $data, array(
                    'redirect_id' => $this->redirect_id
            ));
        } else {
            $data['dateline'] = time();

            XenForo_Application::getDb()->insert('xcfw_redirect_alert', $data);

            $this->redirect_id = XenForo_Application::getDb()->lastInsertId();
        }

        return true;
    }

    public function setFromId($redirect_id)
    {
        $item = XenForo_Application::getDb()->fetchRow('
            SELECT * FROM xcfw_redirect_alert
            WHERE redirect_id=?
        ', array($redirect_id));

        if (!$item) {
            return false;
        }

        $this->setRedirectId($item['redirect_id']);
        $this->setUserId($item['user_id']);
        $this->setMessage($item['message']);
        $this->setMessageParams($item['message_params']);
        $this->setLink($item['link']);
        $this->setLinkType($item['link_type']);
        $this->setLinkParams($item['link_params']);

        return $this;
    }

    /**
     * @return mixed
     */
    public function getRedirectId()
    {
        return $this->redirect_id;
    }

    /**
     * @param mixed $redirect_id
     */
    public function setRedirectId($redirect_id)
    {
        $this->redirect_id = $redirect_id;
    }

    /**
     * @return mixed
     */
    public function getUserId()
    {
        return $this->user_id;
    }

    /**
     * @param mixed $user_id
     */
    public function setUserId($user_id)
    {
        $this->user_id = $user_id;
    }

    /**
     * @return mixed
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param mixed $message
     */
    public function setMessage($message)
    {
        $this->message = $message;
    }

    /**
     * @return mixed
     */
    public function getMessageParams()
    {
        if (!is_array($this->message_params) AND !empty($this->message_params)) {
            return unserialize($this->message_params);
        }
        return $this->message_params;
    }

    /**
     * @param mixed $message_params
     */
    public function setMessageParams($message_params)
    {
        if (is_array($message_params)) {
            $message_params = serialize($message_params);
        }
        $this->message_params = $message_params;
    }

    /**
     * @return mixed
     */
    public function getLink()
    {
        return $this->link;
    }

    /**
     * @param mixed $link
     */
    public function setLink($link)
    {
        $this->link = $link;
    }

    /**
     * @return string
     */
    public function getLinkType()
    {
        return $this->link_type;
    }

    /**
     * @param string $link_type
     */
    public function setLinkType($link_type)
    {
        $this->link_type = $link_type;
    }

    /**
     * @return array
     */
    public function getLinkParams()
    {
        if (!is_array($this->link_params) AND !empty($this->link_params)) {
            return unserialize($this->link_params);
        }

        return $this->link_params;
    }

    /**
     * @param array $link_params
     */
    public function setLinkParams($link_params)
    {
        if (is_array($link_params)) {
            $link_params = serialize($link_params);
        }

        $this->link_params = $link_params;
    }
}