<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/

class XenCentral_Framework_Interface_Core {
    public function prepareUserInformation($userinfo)
    {
        return $userinfo;
    }

    public final function getCorePhrase($phraseKey, $info = array())
    {
        return new XenForo_Phrase($phraseKey, $info);
    }

    public function getPhrase($phraseKey, $info=array())
    {
        return $this->getCorePhrase($phraseKey, $info);
    }

    public function prepareErrors($errors)
    {
        foreach($errors AS $key=>$error) {
            $errors[$key]=$this->getPhrase($error['key'], $error['info']);
        }
        return $errors;
    }

    public function isAdmin()
    {
        return false;
    }

    public function getOption($option)
    {
        $options=XenForo_Application::getOptions();
        return $options->get($option);
    }

    public function sendEmail($user, $subject, $message)
    {
        // TODO send email here
    }

    public function sendPrivateMessage($user, $subject, $message)
    {
        return false;
        // TODO send PM here
    }

    public function getCurrentUserId()
    {
        return XenForo_Visitor::getUserId();
    }

    /**
     * @return XenCentral_Framework_Interface_Database
     */
    public function getDb()
    {
        static $database;

        if(is_null($database)) {
            $database=new XenCentral_Framework_Interface_Database();
        }

        return $database;
    }
}