<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/

class XenCentral_Framework_Input
{
    const TYPE_BOOLEAN = 'boolean';

    const TYPE_STRING = 'string';

    const TYPE_BINARY = 'binary';

    const TYPE_INT = 'int';

    const TYPE_UINT = 'uint';

    const TYPE_FLOAT = 'float';

    const TYPE_ARRAY = 'array';

    const TYPE_NOCLEAN = 'noclean';

    const TYPE_NOHTML = 'nohtml';

    const TYPE_NUM = 'num';

    const TYPE_UNUM = 'unum';

    protected static $_sourceMappaing = array(
        'p' => '_POST',
        'g' => '_GET',
        'r' => '_REQUEST',
        's' => '_SERVER',
        'c' => '_COOKIE'
    );

    public static function getPageArguments($exclude = array())
    {
        $return = $_GET;

        if (is_array($exclude)) {
            foreach ($exclude AS $key) {
                if (isset($return[$key])) {
                    unset($return[$key]);
                }
            }
        }

        return $return;
    }


    public static function getRequest($source, $key, $type, $info = array())
    {
        if (isset($GLOBALS[self::$_sourceMappaing[$source]][$key])) {
            $value = $GLOBALS[self::$_sourceMappaing[$source]][$key];
        }
        else {
            $value = null;
        }

        return self::filter($type, $value, $info);
    }

    public static function getRawRequest($source, $key, $type, $info = array())
    {
        if (isset(${self::$_sourceMappaing[$source]}[$key])) {
            $value = ${self::$_sourceMappaing[$source]}[$key];
        }
        else {
            $value = null;
        }

        return $value;
    }

    public static function getRequestAsArray($source, $values)
    {
        $input = array();

        foreach ($values AS $key => $type) {
            $input[$key] = self::getRequest($source, $key, $type);
        }

        return $input;
    }

    public static function getExistingRequestAsArray($source, $values)
    {
        $input = array();

        foreach ($values AS $key => $type) {
            $input[$key] = self::getExistingRequest($source, $key, $type);
        }

        return $input;
    }

    public static function getExistingRequest($source, $key, $type, $info = array())
    {
        $var = self::$_sourceMappaing[$source];
        if (isset($GLOBALS[$var][$key])) {
            $value = $GLOBALS[$var][$key];
        }
        else {
            return null;
        }

        return self::filter($type, $value, $info);
    }

    public static function paramIsSet($paramName)
    {
        return isset($_REQUEST[$paramName]);
    }

    public static function filter($type, $value, $info = array())
    {
        switch ($type) {
            case self::TYPE_STRING :
                if (isset($info['noTrim']) && $info['noTrim']) {
                    return strval($value);
                }
                else {
                    return trim(strval($value));
                }
            case self::TYPE_NOHTML :
                if (isset($info['noTrim']) && $info['noTrim']) {
                    $value = strval($value);
                }
                else {
                    $value = trim(strval($value));
                }
                return strip_tags($value);
            case self::TYPE_BINARY :
                return strval($value);

            case self::TYPE_UINT :
                $value = intval($value);
                return ($value < 0 ? 0 : $value);

            case self::TYPE_INT :
                return intval($value);

            case self::TYPE_FLOAT :
                return floatval($value);

            case self::TYPE_BOOLEAN :
                return ($value ? 1 : 0);

            case self::TYPE_ARRAY :
                return (array)$value;

            case self::TYPE_NUM:
                return strval($value) + 0;

            case self::TYPE_UNUM:
                $value = strval($value) + 0;
                if ($value < 0) $value = 0;
                return $value;

            case self::TYPE_NOCLEAN :
                return $value; // unmodified
            default :
                throw new Exception("Unknown field type specified - $info[type].");
        }
    }
}