<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/


class XenCentral_Framework_Hooks
{
    public static function clearCache()
    {
        self::_getModel('XenCentral_Framework_Model_Cache')->clean(Zend_Cache::CLEANING_MODE_OLD);
    }

    public static function loadModel($class, array &$extend)
    {
        if ($class == 'XenForo_Model_AddOn' && !in_array('XenCentral_Framework_Model_AddOn', $extend)) {
            $extend[] = 'XenCentral_Framework_Model_AddOn';
        }
    }

    public static function postDispatch(XenForo_Controller $controller, $controllerResponse, $controllerName, $action)
    {
        if (!file_exists(dirname(__FILE__) . '/Resources/addOnConfig.php')) {
            return;
        }

        if (
                (
                        $controller instanceof XenForo_ControllerAdmin_AdminTemplate
                        OR $controller instanceof XenForo_ControllerAdmin_Template
                )
                AND $action == 'SaveMultiple'
        ) {
            $data = $controller->getInput()->filter(array(
                    'template_id' => XenForo_Input::UINT,
                    'addon_id' => XenForo_Input::STRING,
                    'titleArray' => array(XenForo_Input::STRING, array('array' => true))
            ));
            $data['prefix'] = explode('_', $data['titleArray'][$data['template_id']]);
            $data['prefix'] = reset($data['prefix']);
            $data['callback_class'] = '';
        } else if (
                $controller instanceof XenForo_ControllerAdmin_Phrase
                AND $action == 'Save'
        ) {
            $data = $controller->getInput()->filter(array(
                    'addon_id' => XenForo_Input::STRING,
                    'title' => XenForo_Input::STRING
            ));
            list($data['prefix']) = explode('_', $data['title']);
            $data['callback_class'] = '';
        } else if (
                $controller instanceof XenForo_ControllerAdmin_CodeEventListener
                AND $action == 'Save'
        ) {
            $data = $controller->getInput()->filter(array(
                    'addon_id' => XenForo_Input::STRING,
                    'callback_class' => XenForo_Input::STRING
            ));
            $data['prefix'] = '';
        } else if (
                $controller instanceof XenForo_ControllerAdmin_AddOn
                AND $action == 'Save'
        ) {
            $data = $controller->getInput()->filter(array(
                    'addon_id' => XenForo_Input::STRING
            ));
            $data['prefix'] = $data['addon_id'];
        }

        if (!empty($data)) {
            $config = array();
            include dirname(__FILE__) . '/Resources/addOnConfig.php';
            foreach ($config AS $addOnId => $addOn) {
                if (empty($addOn['allowed_prefix'])) {
                    $addOn['allowed_prefix'] = array();
                }
                $addOn['allowed_prefix'][] = $addOn['prefix'];
                if (
                        $addOnId == $data['addon_id']
                        OR !empty($data['prefix']) AND $data['prefix'] == $addOn['prefix']
                        OR !empty($data['callback_class']) AND $data['callback_class'] == $addOn['listener']
                        OR !empty($data['callback_class']) AND strpos($addOn['listener'], $data['callback_class']) === 0
                ) {
                    if (
                            $addOnId != $data['addon_id']
                            OR !empty($data['prefix']) AND !in_array($data['prefix'], $addOn['allowed_prefix'])
                            OR !empty($data['callback_class']) AND $data['callback_class'] != $addOn['listener'] AND strpos($addOn['listener'], $data['callback_class']) === 0
                    ) {
                        throw new XenForo_Exception("Data is saved but addon and prefix/callback do not match: {$data['addon_id']} - {$data['prefix']}");
                    }
                    if ($addOn['path']) {
                        if (!file_exists($addOn['path'])) {
                            throw new XenForo_Exception("Addon path is incorrect - $addOnId");
                        }
                        if (!is_writable($addOn['path'])) {
                            throw new XenForo_Exception("Addon path is specifed but is not writable - $addOnId");
                        }

                        // export product XML
                        $xml = self::_getAddOnModel()->getAddOnXml(self::_getAddOnModel()->getAddOnById($addOnId));
                        file_put_contents($addOn['path'], $xml->saveXml());
                    }
                    break;
                }
            }
        }
    }

    public static function templateCreate(&$templateName, array &$params, XenForo_Template_Abstract $template)
    {
        if ($templateName == 'PAGE_CONTAINER') {
            if ($template instanceof XenForo_Template_Admin) {
                if (XenForo_Application::getConfig()->get('debug')) {
                    $template->addRequiredExternal('js', 'js/XenCentral/Common/admin_tools.js');
                }
            } else {
                $template->preloadTemplate('xcfw_copyright');
            }
        }
    }

    public static function getProductCopyright($productId)
    {
        // compatibility with MulitSite
        $boardUrl = XenForo_Application::getOptions()->get('boardUrl_original');
        if (!$boardUrl) {
            $boardUrl = XenForo_Application::getOptions()->get('boardUrl');
        }

        $boardHost = parse_url($boardUrl, PHP_URL_HOST);

        $boardHost = explode('.', $boardHost);

        if ($boardHost[0] == 'www') {
            array_shift($boardHost);
        }

        $boardHost = implode('.', $boardHost);

        $cacheId = 'xcfw_copyright_' . md5($productId . $boardHost);

        $copyright = self::_getCacheModel()->load($cacheId);

        if ($copyright === false) {
            // try remote request
            $client = new Zend_Http_Client('http://xencentral.com/copyright/');
            $client->setParameterGet(array(
                    'productId' => $productId,
                    'siteDomain' => $boardHost
            ));
            $client->setConfig(array(
                    'timeout' => 3
            ));

            try {
                $response = $client->request('GET');
                $body = $response->getBody();
            } catch (Exception $ex) {
                $body = false;
            }

            if ($body) {
                try {
                    $bodyJson = json_decode($body);
                } catch (Exception $ex) {
                    $bodyJson = false;
                }
            } else {
                $bodyJson = false;
            }

            if (!$body OR !$bodyJson) {
                // remote request failed
                // try to get the old copyright
                $copyright = self::_getCacheModel()->load($cacheId, true);
                if ($copyright) {
                    // update cache to skip further checks for more days
                    self::_getCacheModel()->save($copyright, $cacheId, array(), 10 * 86400);
                    return $copyright;
                } else {
                    // save branding-free info for 1 hour
                    self::_getCacheModel()->save(array(
                            'brandingFree' => true
                    ), $cacheId, array(), 7200);
                    return false;
                }
            }

            $copyright = array();

            foreach ($bodyJson AS $key => $value) {
                $copyright[$key] = $value;
            }

            // we have copyright info, save it into cache
            self::_getCacheModel()->save(serialize($copyright), $cacheId, array(), 30 * 86400);
        }

        if ($copyright && !is_array($copyright)) {
            $copyright = unserialize($copyright);
        }

        if (isset($copyright['brandingFree'])) {
            return false;
        }

        return $copyright;
    }

    public static function templateHookUserCriteriaSpecific($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
    {
        $options = array();

        /** @var XenCentral_Framework_Model_GeoCoding $model */
        $model = self::_getModel('XenCentral_Framework_Model_GeoCoding');

        $countryList = $model->getCountryArray();
        $userCriteria = $template->getParam('userCriteria');
        $selectedCountries = isset($userCriteria['ip_country']) ? $userCriteria['ip_country']['country'] : array();
        foreach ($countryList AS $code => $name) {
            if (!$code) {
                continue;
            }

            $options[$code] = array(
                    'label' => $name,
                    'value' => $code,
                    'selected' => in_array($code, $selectedCountries)
            );
        }

        $template->setParam('countryOptions', $options);

        $contents .= $template->create('xcfw_country_criteria', $template->getParams());

        $contents .= $template->create('xcfw_mobile_criteria', $template->getParams());
    }

    public static function criteriaUser($rule, array $data, array $user, &$returnValue)
    {
        switch ($rule) {
            case 'is_mobile':
                require_once XenForo_Application::getInstance()->getRootDir() . '/library/XenCentral/Framework/Resources/MobileDetect.php';
                $tabletDetect = new Mobile_Detect();

                if (
                        XenForo_Visitor::isBrowsingWith('mobile')
                        AND !$tabletDetect->isTablet()
                ) {
                    $returnValue = true;
                }
                break;
            case 'is_tablet':
                require_once XenForo_Application::getInstance()->getRootDir() . '/library/XenCentral/Framework/Resources/MobileDetect.php';
                $tabletDetect = new Mobile_Detect();
                if ($tabletDetect->isTablet()) {
                    $returnValue = true;
                }
                break;
            case 'ip_country':
                if (empty($data['country'])) {
                    break;
                }

                if ($user['user_id'] == XenForo_Visitor::getUserId()) {
                    $ip = false;
                    if (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) {
                        $ip = $_SERVER['HTTP_CF_CONNECTING_IP'];
                    } else if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
                        $ip = $_SERVER['HTTP_CLIENT_IP'];
                    } else if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
                    } else if (!empty($_SERVER['REMOTE_ADDR'])) {
                        $ip = $_SERVER['REMOTE_ADDR'];
                    }
                    if ($ip) {
                        $countryCode = self::_getModel('XenCentral_Framework_Model_GeoCoding')->getCountryCode($ip);
                        if (in_array($countryCode, $data['country'])) {
                            $returnValue = true;
                        }
                    }
                }
                break;
        }
    }

    /**
     * @return XenCentral_Framework_Model_Cache
     */
    protected static function _getCacheModel()
    {
        return self::_getModel('XenCentral_Framework_Model_Cache');
    }

    /**
     * @return XenForo_Model_AddOn
     */
    protected static function _getAddOnModel()
    {
        return self::_getModel('XenForo_Model_AddOn');
    }

    /**
     * @param $modelName
     * @return XenForo_Model
     */
    protected static function _getModel($modelName)
    {
        static $modelCache;

        if (isset($modelCache[$modelName])) {
            return $modelCache[$modelName];
        }

        $modelCache[$modelName] = XenForo_Model::create($modelName);

        return $modelCache[$modelName];
    }
}