<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/


/**
* Data writer for manager items
*
* @package XenCentral
*/
abstract class XenCentral_Framework_DataWriter_Manager extends XenForo_DataWriter
{
	/**
	 * Title of the phrase that will be created when a call to set the
	 * existing data fails (when the data doesn't exist).
	 *
	 * @var string
	 */
	protected $_existingDataErrorPhrase;
	
	/**
	 * @var XenCentral_Framework_Tools_ManagerInfo
	 */
	protected $_managerInfo;
	
	/**
	* Gets the fields that are defined for the table. See parent for explanation.
	*
	* @return array
	*/
	protected function _getFields()
	{
		$this->validateManagerInfo();
		
		return $this->getManagerInfo()->getFields();
	}
	
	public function setManagerInfo($_managerInfo)
	{
		$this->_managerInfo=$_managerInfo;
		
		$this->_existingDataErrorPhrase=$this->getManagerInfo()->getNotFoundErrorPhrase();
	}
	
	public function getManagerInfo()
	{
		return $this->_managerInfo;
	}

	/**
	* Gets the actual existing data out of data that was passed in. See parent for explanation.
	*
	* @param mixed
	*
	* @return array|false
	*/
	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data))
		{
			return false;
		}

		return array($this->getManagerInfo()->getItemTable() => $this->_getItemModel()->getItemById($id));
	}

	/**
	* Gets SQL condition to update the existing record.
	*
	* @return string
	*/
	protected function _getUpdateCondition($tableName)
	{
		return $this->getManagerInfo()->getPrimaryKeyName().' = ' . $this->_db->quote($this->getExisting($this->getManagerInfo()->getPrimaryKeyName()));
	}

	/**
	 * Pre-save handling.
	 */
	final protected function _preSave()
	{
		// force custom presave function to be called
		$this->_customPreSave();
	}
	
	protected abstract function _customPreSave();

	/**
	 * Post-save handling.
	 */
	protected function _postSave()
	{
		
	}

	/**
	 * Post-delete handling.
	 */
	protected function _postDelete()
	{
		
	}
	
	/**
	 * @return XenForo_Model
	 */
	protected function _getItemModel()
	{
		$model=$this->getModelFromCache($this->getManagerInfo()->getModelClassName());
		$model->setManagerInfo($this->getManagerInfo());
		return $model;
	}
	
	protected abstract function validateManagerInfo();
}