<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/

class XenCentral_Framework_ControllerPublic_PaymentApi extends XenForo_ControllerPublic_Abstract
{
    public function actionProcessManually()
    {
        if(!XenForo_Visitor::getInstance()->hasAdminPermission('xcfw_can_manage_payments')) {
            return $this->responseNoPermission();
        }

        $txn_id=$this->getInput()->filterSingle('txn_id', XenForo_Input::STRING);

        $transaction=$this->_getPaymentApiModel()->getPayments(array(
            'txn_id'=>$txn_id
        ), array());

        if(!$transaction) {
            return $this->getNotFoundResponse();
        }
        $transaction=reset($transaction);
        $request=unserialize($transaction['request']);
        foreach($request AS $key=>$value) {
            if(in_array($key, array('_xfToken'))) {
                continue;
            }

            $_POST[$key]=$value;
        }
        $this->getRequest()->setParam('PaymentMethod', 'Manual');

        return $this->responseReroute($transaction['purchase_handler'], 'purchase-notify');
    }

    public function actionPaymentInstructions()
    {
        /** @var XenCentral_PaymentApi_Method $paymentMethod */
        $paymentMethod=$this->getHelper('XenCentral_Framework_ControllerHelper_PaymentApi')->assertValidPaymentMethod(true);

        if($paymentMethod->validateRequest()) {

            $instructions=$paymentMethod->getSetting('instructions');

            $handler = $this->getInput()->filterSingle('purchase_handler', XenForo_Input::STRING);

            if (!class_exists($handler)) {
                return $this->responseMessage('Invalid payment handler specified.');
            }

            $txn_id = $this->_getPaymentApiModel()->createManualPayment(
                    $paymentMethod->getTransactionId(),
                    $this->getInput()->filterSingle('custom', XenForo_Input::STRING),
                    $handler
            );

            return $this->responseView('XenCentral_Framework_ViewPublic_PaymentInstructions', 'xcfw_payment_instructions', array(
                'instructions'=>$instructions,
                'txn_id'=>$txn_id
            ));
        }

        return $this->responseError('Unknown error occurred. Please try again or contact site administrator.');
    }

    /**
     * @return XenCentral_Framework_Model_PaymentApi
     */
    protected function _getPaymentApiModel()
    {
        return $this->getModelFromCache('XenCentral_Framework_Model_PaymentApi');
    }
}