<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/

class XenCentral_Framework_ControllerHelper_PaymentApi extends XenForo_ControllerHelper_Abstract
{
    /**
     * @param $debugMode
     * @return XenCentral_PaymentApi_Method
     * @throws XenForo_ControllerResponse_Exception
     */
    public function assertValidPaymentMethod($debugMode)
    {
        $Method = $this->_controller->getInput()->filterSingle('PaymentMethod', XenForo_Input::STRING);
        if (!$Method) {
            // just simple thank you page
            throw new XenForo_ControllerResponse_Exception(
                    $this->_controller->responseMessage(new XenForo_Phrase('xcfw_thank_you_for_payment'))
            );
        }

        $paymentApi = XenCentral_PaymentApi_Module::getInstance();

        try {
            $paymentMethod = $paymentApi->getMethod($Method);
        } catch (Exception $ex) {
            throw new XenForo_ControllerResponse_Exception(
                    $this->_controller->responseError(new XenForo_Phrase(
                            'xcfw_unable_to_validate_payment_error_x', array('error' => $ex->getMessage())
                    ))
            );
        }

        if (strtolower($Method) == 'local') {
            if (XenForo_Visitor::getInstance()->isSuperAdmin()) {
                $paymentMethod->setDebugMode(true);
            } else {
                throw $this->_controller->getNoPermissionResponseException();
            }
        } else {
            if ($debugMode) {
                $paymentMethod->setDebugMode($debugMode);
            }
        }

        return $paymentMethod;
    }
}