<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/


class XenCentral_Framework_ControllerAdmin_Cleanup extends XenForo_ControllerAdmin_Abstract
{
    public function actionIndex()
    {

    }

    public function actionUsergroupCleanup()
    {
        $usergroupModel = $this->_getUsergroupModel();
        $usergroups=$usergroupModel->getAllUserGroups();

        foreach ($usergroups AS $usergroup) {
            if($usergroup['user_group_id']<5) {
                continue;
            }

            $dataManagerClass = 'XenForo_DataWriter_UserGroup';
            /** @var $dataWriter XenForo_DataWriter_UserGroup */
            try {
                $dataWriter = XenForo_DataWriter::create($dataManagerClass);
                $dataWriter->setExistingData($usergroup);
                $dataWriter->delete();
            } catch (Exception $ex) {
                $a = 0;
            }
        }
        echo ('All usergroups are deleted');
    }


    public function actionBoardCleanup()
    {
        $nodeModel = $this->_getNodeModel();
        $addonModel=$this->_getAddOnModel();

        $addonOns= $addonModel->getAllAddOns();

        $addonTitles=XenForo_Application::arrayColumn($addonOns, 'title');

        $nodes = $nodeModel->prepareNodesForAdmin($nodeModel->getAllNodes());

        $index = 0;

        foreach ($nodes AS $node) {
            if ($node['node_type_id'] == 'Page') {
                continue;
            }

            if(in_array($node['title'], $addonTitles) OR $node['title']=='DO NOT DELETE') {
                continue;
            }

            $index++;

            if ($index == 1) {
                continue;
            }

            $dataManagerClass = 'XenForo_DataWriter_' . $node['node_type_id'];
            /** @var $dataWriter XenForo_DataWriter_Forum */
            try {
                $dataWriter = XenForo_DataWriter::create($dataManagerClass);
                $dataWriter->setExistingData($node);
                $dataWriter->delete();
            } catch (Exception $ex) {
                $a = 0;
            }
        }

        // delete all threads with no nodes
        $db=XenForo_Application::getDb();

        $a=$db->query('
            DELETE thread.* FROM xf_thread AS thread
            LEFT JOIN xf_node AS node ON node.node_id=thread.node_id
            WHERE node.node_id IS NULL
        ');

        $a =$db->query('
            DELETE post.* FROM xf_post AS post
            LEFT JOIN xf_thread AS thread ON thread.thread_id=post.thread_id
            WHERE thread.thread_id IS NULL
        ');

        $a =$db->query('
            DELETE user.* FROM xf_user AS user
            LEFT JOIN xf_post AS post ON post.user_id=user.user_id
            WHERE post.post_id IS NULL
            AND user.user_id>1
        ');
        $a =$db->query('
            DELETE user_group.* FROM xf_user_group AS user_group
            LEFT JOIN xf_user AS user ON user.user_group_id=user_group.user_group_id
            WHERE user.user_id IS NULL
            AND user_group.user_group_id>4
        ');
        $a =$db->query('
            DELETE relation.* FROM xf_user_group_relation AS relation
            LEFT JOIN xf_user AS user ON user.user_id=relation.user_id
            WHERE user.user_id IS NULL
        ');
        $a =$db->query('
            TRUNCATE TABLE xf_conversation_master;
        ');
        $a =$db->query('
            TRUNCATE TABLE xf_conversation_message;
        ');

        $a =$db->query('
            TRUNCATE TABLE xf_conversation_recipient;
        ');
        $a =$db->query('
            TRUNCATE TABLE xf_conversation_user;
        ');
        $a =$db->query('
            TRUNCATE TABLE xf_search_index;
        ');


        die('The board is cleaned up from data.');
    }

    public function actionThreadCleanup()
    {
        // remove all users
        $fetchOptions = array(
            'perPage' => 100,
            'page'=>max(1, $this->getInput()->filterSingle('page', XenForo_Input::UINT))
        );

        /** @var XenForo_Model_Thread $threadModel */
        $threadModel = $this->getModelFromCache('XenForo_Model_Thread');
        $threads = $threadModel->getThreads(array(), $fetchOptions);

        $index = 0;
        foreach ($threads AS $thread) {
            $index++;
            try {
                $dataWriter = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');
                $dataWriter->setExistingData($thread);
                $dataWriter->delete();
            } catch (Exception $ex) {
                echo $ex->getMessage().'<br />';
            }
            echo $thread['thread_id'] . ' is deleted <br />';
            flush();
            @ob_end_flush();
        }

        if ($index == 0) {
            die('Done !');
        }

        $url = XenForo_Link::buildAdminLink('xcfw/ThreadCleanup');
        ?>
        <script type="text/javascript">window.location = '<?php echo $url;?>';</script>
        <?php
        exit;
    }

    public function actionDeleteUserFields()
    {
        $fieldModel = $this->_getFieldModel();

        $fields = $fieldModel->prepareUserFields($fieldModel->getUserFields());

        foreach ($fields AS $field) {
            $writer = XenForo_DataWriter::create('XenForo_DataWriter_UserField');
            $writer->setExistingData($field);
            $writer->delete();
        }

        die('User fields are deleted');
    }

    public function actionDeleteThreadPrefixes()
    {
        $prefixModel = $this->_getPrefixModel();

        $prefixes = $prefixModel->getAllPrefixes();

        foreach ($prefixes AS $prefix) {
            $writer = XenForo_DataWriter::create('XenForo_DataWriter_ThreadPrefix');
            $writer->setExistingData($prefix);
            $writer->delete();
        }

        die('Thread prefixes are deleted');
    }

    public function actionCleanupUsers()
    {
        $page = $this->_input->filterSingle('page', XenForo_Input::INT);
        if (!$page) {
            $page = 1;
        }

        // remove all users
        $fetchOptions = array(
            'perPage' => 100
        );

        $userModel = $this->_getXenForoUserModel();

        $users = $userModel->getUsers(array(), $fetchOptions);

        $index = 0;
        foreach ($users AS $user) {
            if($user['user_id']==1) {
                continue;
            }
            $index++;
            try {
                $dataWriter = XenForo_DataWriter::create('XenForo_DataWriter_User');
                $dataWriter->setExistingData($user);
                $dataWriter->delete();
            } catch (Exception $e) {
            }

            echo $user['user_id'] . ' is deleted <br />';
            flush();
            @ob_end_flush();
        }

        if ($index == 0) {
            // delete user groups
            /** @var XenForo_Model_UserGroup $model */
            $model=XenForo_Model::create('XenForo_Model_UserGroup');
            $usergroups=$model->getAllUserGroups();
            foreach($usergroups AS $usergroup) {
                if($usergroup['user_group_id']>5) {
                    $dataWriter = XenForo_DataWriter::create('XenForo_DataWriter_UserGroup');
                    $dataWriter->setExistingData($usergroup);
                    $dataWriter->delete();
                }
            }

            die('Done');
        }

        $url = XenForo_Link::buildAdminLink('xcfw/cleanup-users', null, array('page' => $page));
        ?>
        <script type="text/javascript">window.location = '<?php echo $url;?>';</script>
    <?php
    }

    /**
     * @return XenForo_Model_Node
     */
    protected function _getNodeModel()
    {
        return $this->getModelFromCache('XenForo_Model_Node');
    }

    /**
     * @return XenForo_Model_AddOn
     */
    protected function _getAddOnModel()
    {
        return $this->getModelFromCache('XenForo_Model_AddOn');
    }



    /**
     * @return XenForo_Model_User
     */
    protected function _getXenForoUserModel()
    {
        return $this->getModelFromCache('XenForo_Model_User');
    }

    /**
     * @return XenForo_Model_UserField
     */
    protected function _getFieldModel()
    {
        return $this->getModelFromCache('XenForo_Model_UserField');
    }

    /**
     * @return XenForo_Model_ThreadPrefix
     */
    protected function _getPrefixModel()
    {
        return $this->getModelFromCache('XenForo_Model_ThreadPrefix');
    }

    /**
     * @return XenForo_Model_UserGroup
     */
    protected function _getUsergroupModel()
    {
        return $this->getModelFromCache('XenForo_Model_UserGroup');
    }


}
