<?php
/**
* @package XenCentral Framework
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @version 1.4.1
* @revision 125
*/

	
class XenCentral_Framework_AlertHandler_Redirect extends XenForo_AlertHandler_Abstract
{
	public function getContentByIds(array $contentIds, $model, $userId, array $viewingUser)
	{
		$data=XenForo_Application::getDb()->fetchAll('
			SELECT * FROM xcfw_redirect_alert
			WHERE redirect_id IN ('. XenForo_Application::getDb()->quote($contentIds).')
			AND user_id=?
		', array(
			$userId
		));

		$content=array();

		foreach ($data as $item) {
			$content[$item['redirect_id']]=$item;
		}

		return $content;
	}

	protected function _prepareAlertAfterAction(array $item, $content, array $viewingUser)
	{
		$item=parent::_prepareAlertAfterAction($item, $content, $viewingUser);

		if($content['message_params']) {
			$item['extra']['message']=new XenForo_Phrase($content['message'], unserialize($content['message_params']));
		} else {
			$item['extra']['message'] = $content['message'];
		}

		$item['extra']['link'] = XenForo_Link::buildPublicLink('xcfw/private-redirect', null, array('redirect_id'=> $content['redirect_id']));

		return $item;
	}

	protected function _getDefaultTemplateTitle($contentType, $action)
	{
		return 'xcfw_alert_redirect';
	}


}