<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

class XenCentral_AdServer_ViewPublic_Stats extends XenForo_ViewPublic_Base
{
    public function renderJson()
    {
        $output['data'] = $this->getParams();
        if(!empty($output['data']['error'])) {
            $output['error']=$output['data']['error'];
        }

        $output = $this->_renderObjects($output);

        return $output;
    }

    protected function _renderObjects($array)
    {
        foreach ($array AS $index => $value) {
            if (is_array($value)) {
                $array[$index] = $this->_renderObjects($value);
            } else if (is_object($value)) {
                if($value instanceof XenForo_Phrase) {
                    $array[$index] = $value . '';
                } else {
                    unset($array[$index]);
                }
            }
        }
        return $array;
    }
}