<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

class XenCentral_AdServer_ViewPublic_AbstractBanner extends XenForo_ViewPublic_Base
{
    protected function _getEmbedCode($banner=false)
    {
        if($banner==false) {
            $banner= $this->_params['banner'];
        }

        $randomId = XenCentral_AdServer_Zone::getRandomId();

        $src=XenForo_Link::buildPublicLink('full:ads/delivery', null, array(
            'zones' => $banner['zoneId'],
            'bannerId' => $banner['bannerId'],
            'randomId' => $randomId,
            'safeModeLoaded' => $banner['safe_mode'] ? $banner['bannerId'] : 0
        ));

        return $this->createTemplateObject('xcas_zone_code', array(
            'randomId' => $randomId,
            'src'=> $src,
            'reloadSrc'=> $src,
            'includeScript'=>true,
            'width'=>!empty($this->_params['zone'])?$this->_params['zone']['width']:'',
            'height'=>!empty($this->_params['zone'])?$this->_params['zone']['height']:'',
            'bannerContent'=> $banner['safe_mode'] ? $banner['bannerHtml']:''
        ));
    }
}