<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

class XenCentral_AdServer_Locations_Hooks_ThirdParty_XP_ThreadViewShareAfter extends XenCentral_AdServer_Locations_Hooks_ThirdParty_Abstract
{
    public function getSubGroup()
    {
        return new XenForo_Phrase('xcas_xp');
    }

    public function getHookName()
    {
        return 'thread_view_share_after';
    }

    /**
     * @return String|XenForo_Phrase
     * Title for the location to be used in Admin Panel
     */
    public function getTitle()
    {
        return new XenForo_Phrase('xcas_xp_thread_view_share_after');
    }


    /**
     * @return String
     * Returns unique string identified for the location
     */
    public function getLocationId()
    {
        return 'xp_thread_view_share_after';
    }

    public function allowChangeModificationMode()
    {
        return false;
    }
}