<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

class XenCentral_AdServer_Locations_Hooks_NodeForumLevel2BeforeLastpost extends XenCentral_AdServer_Locations_Hooks_Abstract_Forum
{
    public function getSubGroup()
    {
        return new XenForo_Phrase('xcas_forum');
    }

    public function getHookName()
    {
        return 'node_forum_level_2_before_lastpost';
    }

    /**
     * @return String|XenForo_Phrase
     * Title for the location to be used in Admin Panel
     */
    public function getTitle()
    {
        return new XenForo_Phrase('xcas_node_forum_level_2_before_lastpost');
    }


    /**
     * @return String
     * Returns unique string identified for the location
     */
    public function getLocationId()
    {
        return 'node_forum_level_2_before_lastpost';
    }

    public function allowChangeModificationMode()
    {
        return false;
    }
}