<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

class XenCentral_AdServer_Locations_Hooks_BreadcrumbBottom extends XenCentral_AdServer_Locations_Hooks_Abstract
{
    public function getSubGroup()
    {
        return new XenForo_Phrase('xcas_page_wrapper');
    }

    public function getHookName()
    {
        return 'page_container_breadcrumb_bottom';
    }

    /**
     * @return String|XenForo_Phrase
     * Title for the location to be used in Admin Panel
     */
    public function getTitle()
    {
        return new XenForo_Phrase('xcas_breadcrumb_bottom');
    }


    /**
     * @return String
     * Returns unique string identified for the location
     */
    public function getLocationId()
    {
        return 'page_container_breadcrumb_bottom';
    }

    public function allowChangeModificationMode()
    {
        return true;
    }
}