<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

abstract class XenCentral_AdServer_Locations_Hooks_Abstract extends XenCentral_AdServer_Locations_Abstract
{
    protected $modification_mode='append';

    protected $hook_params;

    protected $template;

    /**
     * @return String
     * Return name of hook for the location where it is executed
     */
    public abstract function getHookName();

    /**
     * @return String|XenForo_Phrase
     * Name of group for locations. Will be used to create tabs in Zone Manager
     */
    public function getGroup()
    {
        return new XenForo_Phrase('xcas_xenforo_hooks');
    }

    /**
     * @return String
     * Each location type should set its template name to be used to render location in Admin Panel
     */
    public function getOptionTemplate()
    {
        return 'xcas_location_hook';
    }

    public function modifyContent(&$content, array $zoneData)
    {
        $placeholder= XenCentral_AdServer_Model_Zone::getZonePlaceholder($zoneData, $this->_forceSafeMode());
        switch($this->getModificationMode())
        {
            case 'prepend':
                $content= $placeholder. $content;
                break;
            case 'append':
                $content=$content . $placeholder;
                break;
            case 'callback':
                $content=$this->_handleContentModification($content, $placeholder);
                break;
            default:
                $content .= $placeholder;
                break;
        }
    }

    public function allowChangeModificationMode()
    {
        return false;
    }

    /**
     * @return String prepend|append|callback
     *
     */
    public function getModificationMode()
    {
        return $this->modification_mode;
    }

    public function setModificationMode($mode)
    {
        if(!in_array($mode, array('prepend', 'append', 'callback'))) {
            throw new Exception("Invalid hook location modification mode is set.");
        }

        $this->modification_mode=$mode;
    }

    public function prepareFromData($locationData)
    {
        $locationData=parent::prepareFromData($locationData);
        $locationData['showModificationType']=$this->allowChangeModificationMode();
        $locationData['hook_name']=$this->getHookName();
        if($this->allowChangeModificationMode()) {
            if(!empty($locationData['modification_type'])) {
                $this->setModificationMode($locationData['modification_type']);
            }
        }
        return $locationData;
    }

    /**
     * @param mixed $hook_params
     */
    public function setHookParams($hook_params)
    {
        $this->hook_params = $hook_params;
    }

    /**
     * @param mixed $template
     */
    public function setTemplate($template)
    {
        $this->template = $template;
    }

    /**
     * @param $content
     * @param $bannerContent
     * @return string
     * To be overriden by child classes that use custom contnet modifications
     */
    protected function _handleContentModification($content, $bannerContent)
    {
        return $content;
    }
}
